setwd("D:/CloudINED/HMBD_partage/Input data, metadata and country-specific codes/DNK")

# ******************************************************************************
#                                Denmark
#
# This file provides the calculations performed on the input data for the DNK,
# as used in the construction of the Human Multiple Births Database
#
# ******************************************************************************


library(dplyr)
library(tidyr)
library(openxlsx)
library(ggplot2)
library(forecast)

  
data <- read.xlsx("DNK_InputData_29.04.2024.xlsx", sheet = "input data")
head(data)

data %>% arrange(Year) -> data

# Data from Statistics Denmark (1850-2018)......................................
data %>%
  mutate(Twin_children = Twin_deliveries * 2,
         Triplet_children = Triplet_deliveries * 3,
         Quadruplet_plus_children = Total_children - Singletons - Twin_children - Triplet_children,
         Multiple_deliveries = Twin_deliveries + Triplet_deliveries + Quadruplet_plus_deliveries,
         Multiple_children = Twin_children + Triplet_children + Quadruplet_plus_children,
         Total_deliveries = Singletons + Multiple_deliveries,
         Twinning_rate = (Twin_deliveries / Total_deliveries) * 1000,
         Multiple_rate = (Multiple_deliveries / Total_deliveries) * 1000) -> data


# Identify outliers.............................................................
outliers_tr <- tsoutliers(data$Twinning_rate)
outliers_mr <- tsoutliers(data$Multiple_rate)

data %>% 
  select(Source, Year, Twinning_rate, Multiple_rate) %>%
  mutate(outlier = ifelse(row_number() %in% outliers_tr$index |
                            row_number() %in% outliers_mr$index,
                          1, 0)) -> check

subset(check, outlier == 1)

# Save data.....................................................................
write.table(data, 
            "D:/CloudINED/HMBD_partage/Pooled database/DNK_ALLDATA.txt",
            row.names = F)



