library(dplyr)
library(tidyr)
library(openxlsx)
library(ggplot2)
library(forecast)

# Set working directory 
setwd("D:/NextCloud/HMBD_partage/Input data, metadata and country-specific codes/GRC")

# ******************************************************************************
#                                   GRECE
# ******************************************************************************

data <- read.xlsx("GRC_InputData_30.09.2024.xlsx", sheet = "input data")
head(data)


data %>%
  mutate(Twin_deliveries = Twin_children / 2,
         Triplet_deliveries = Triplet_children / 3,
         Quadruplet_plus_deliveries = ifelse(is.na(Quadruplet_plus_deliveries),
                                             Quadruplet_plus_children / 4,
                                             Quadruplet_plus_deliveries),
         Multiple_deliveries = Twin_deliveries + Triplet_deliveries + Quadruplet_plus_deliveries,
         Multiple_children = Twin_children + Triplet_children + Quadruplet_plus_children,
         Total_deliveries = Singletons + Multiple_deliveries,
         Twinning_rate = (Twin_deliveries / Total_deliveries) * 1000,
         Multiple_rate = (Multiple_deliveries / Total_deliveries) * 1000) -> data


# Identify outliers.............................................................
outliers_tr <- tsoutliers(data$Twinning_rate)
outliers_mr <- tsoutliers(data$Multiple_rate)

data %>% 
  select(Source, Year, Twinning_rate, Multiple_rate) %>%
  mutate(outlier = ifelse(row_number() %in% outliers_tr$index |
                            row_number() %in% outliers_mr$index,
                          1, 0)) -> check

subset(check, outlier == 1)

# Save data.....................................................................
write.table(data, 
            "D:/NextCloud/HMBD_partage/Pooled database/GRC_ALLDATA.txt",
            row.names = F)




  


