/// <reference path="binder.ts"/>

/********************************************** file : RequestBinder.ts ***********************************************/
class RequestBinder extends binder {
      /* protected*/
     sqliteDb = 'database.sqlite'; 
    /*protected*/
     php = 'query.php';
    
     public getPopTrads(callback ) {
        this.query('getPopTrads', {}, callback);
    }  
    
      /**
     * Retourne la liste de la table Pays + monde trié par lang
     * @param {type} callback
     */
    public getPaysMonde = function(lg : string,callback) {
       // var orderBy = "t1.pays_nom_fr";
        if (lg=="en") {
        //    orderBy= "t1.pays_nom_en";
           this.query('getPaysMonde_en', {}, callback);
        } else {
          this.query('getPaysMonde_fr', {}, callback);
        }
    
    
        //this.query('getPaysMonde', {"order":orderBy}, callback);
    };
    
     /**
     * Retourne la liste de la table Pays
     * @param {type} callback
     */
    public getPays = function(callback) {
        this.query('getPays', {}, callback);
    };
    
    
     
    /**
     * Retourne la fichie statistique d'immigration pour un pays
     * @param int id
     * @param int annee
     * @param {type} callback
     */
    public getPaysFile = function(annee,idZone,callback) {
        this.query('getPaysFile', {"annee": annee,"id":idZone}, callback);
    };
    
    
    
    
    
    
    public get_stocks_immigrants_effectif = function(annee ,callback:(data: any) => any ) {
        this.query('get_stocks_immigrants_effectif', { }, callback);
    };
    
    public get_stocks_immigrants_proportion = function(annee ,callback:(data: any) => any ) {
        this.query('get_stocks_immigrants_proportion', { }, callback);
    };
    
    public get_stocks_immigrants_effectifAndPopulation = function(annee ,callback:(data: any) => any ) {
        this.query('get_stocks_immigrants_effectifAndPopulation', {"annee": annee}, callback);
    };
    
    public get_flux_migratoryGrowth_effectif = function(annee ,callback:(data: any) => any ) {
        this.query('get_flux_migratoryGrowth_effectif', {"annee": annee}, callback);
    };
    
    public get_flux_migratoryGrowth_taux = function(annee ,callback:(data: any) => any ) {
        this.query('get_flux_migratoryGrowth_taux', {"annee": annee}, callback);
    };

    public get_flux_totalIncrease_effectif = function(annee ,callback:(data: any) => any ) {
        this.query('get_flux_totalIncrease_effectif', {"annee": annee}, callback);
    };
    
    public get_flux_totalIncrease_taux = function(annee ,callback:(data: any) => any ) {
        this.query('get_flux_totalIncrease_taux', {"annee": annee}, callback);
    };
    
    /**
     * Retourne la fichie statistique d'immigration pour un pays
     * @param int annee
     * @param (data: any) => any callback
     */
    public get_population_effectif = function(annee ,callback:(data: any) => any ) {
        this.query('get_population_effectif', {"annee": annee}, callback);
    };
    
    
    /**********************    ANCIENNES REQUETES *********************************/
    
    /**
     * Retourne la liste des zones geograpiques
     * @param {type} callback
     */
    public getZones = function(callback) {
        this.query('getZones', {}, callback);
    };
    
    
    /**
     * Retourne la liste des pays par zones geograpiques
     * @param {type} callback
     */
    public getPaysZone = function(idZone, callback) {
        this.query('getPaysZone', {"id":idZone}, callback);
    };

    /**
     * Retourne les données pour le monde pour une année donnée
     *
     * @param int annee
     * @param {type} callback
     */
    public getDataForYear = function(annee, callback) {
        this.query('getDataForYear', {"annee": annee}, callback);
    };    
    
       
    /**
     * Retourne les données pour une zone => Pour place.
     *
     * @param int id
     * @param {type} callback
     */
    public getDataForZonePlace = function(id, callback) {
        this.query('getDataForZonePlace', {"id": id}, callback);
    };
    
    /**
     * Retourne les données pour une zone.
     *
     * @param int id
     * @param {type} callback
     */
    public getDataForZone = function(id, callback) {
        this.query('getDataForZone', {"id": id}, callback);
    };
        
    /**
     * Retourne les données "génération" pour une zone et une année donnée.
     *
     * @param int id
     * @param int annee
     * @param {type} callback
     */
    public getDataForZoneGen = function(id, callback) {
        this.query('getDataForZoneGen', {"id": id}, callback);
    };
    
    /**
     * Retourne les données de "survie" pour une zone et un age donné.
     *
     * @param int id
     * @param int age
     * @param {type} callback
     */
    public getDataForSurvie = function(id, callback) {
        this.query('getDataForSurvie', {"id": id}, callback);
    };
   

}
