﻿// (c) ammap.com | SVG (in JSON format) map of South Sudan - High
// areas: {id:"SS-BN"},{id:"SS-BW"},{id:"SS-EC"},{id:"SS-EE"},{id:"SS-EW"},{id:"SS-JG"},{id:"SS-LK"},{id:"SS-NU"},{id:"SS-UY"},{id:"SS-WR"}
AmCharts.maps.southSudanHigh={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"24.151005",
				"topLatitude":"12.219553",
				"rightLongitude":"35.871799",
				"bottomLatitude":"3.479946"
			}
		},
		"g":{
			"path":[
				{
					"id":"SS-BN",
					"title":"Northern Bahr el Ghazal",
					"d":"M168.308,205.863L173.552,206.254L194.272,198.933L200.837,197.628L211.999,197.033L219.54,197.499L236.601,197.694L245.823,198.77L253.323,198.019L262.381,216.309L311.388,216.136L310.644,212.557L310.644,212.557L312.907,212.413L320.722,215.837L323.389,219.431L319.557,224.762L317.972,224.339L313.463,226.746L312.403,229.777L313.881,232.07L312.958,232.981L311.255,233.339L307.53,236.548L307.764,237.236L307.764,237.236L305.663,238.368L302.256,238.623L299.93,238.171L298.416,237.52L293.049,240.005L290.378,240.217L288.126,239.298L285.994,238.961L283.87,239.792L279.048,242.896L276.905,243.564L275.629,243.145L275.021,241.921L274.345,241.717L273.534,242.805L272.453,243.009L271.845,242.601L269.344,243.621L268.668,243.484L267.924,242.397L267.249,242.533L265.897,243.96L265.221,244.028L264.41,242.193L262.382,241.377L261.841,241.785L261.166,243.145L260.49,243.213L258.935,241.853L257.448,243.077L256.299,242.737L253.934,242.873L252.745,243.381L251.771,242.805L251.298,241.853L251.027,241.717L250.216,242.329L249.676,241.445L249.024,241.173L248.392,241.513L247.851,242.805L247.107,242.737L246.161,241.853L245.485,241.785L244.133,243.756L243.838,243.638L244.474,242.293L242.082,242.447L241.825,243.111L239.396,242.674L238.351,243.482L235.987,243.563L234.652,244.922L233.896,245.229L233.703,246.296L232.336,246.426L231.387,246.927L232.127,247.688L232.416,251.051L233.446,252.521L234.105,255.14L235.698,256.983L236.116,258.325L238.11,259.715L236.52,261.616L237.114,262.603L237.05,263.637L235.988,265.381L235.346,265.592L233.592,267.272L230.279,266.142L228.688,265.931L228.172,265.576L225.776,265.673L227.545,269.017L229.346,277.531L234.219,281.681L236.383,285.132L232.774,287.099L232.774,287.099L230.595,286.31L227.472,287.3L227.012,287.957L187.789,307.837L178.373,314.096L144.231,292.366L140.142,278.474L138.475,268.474L138.096,264.083L137.943,257.024L138.223,254.222L137.209,252.931L137.614,250.893L137.141,249.465L137.43,248.602L134.662,246.847L134.062,234.77L139.402,177.121L139.402,177.121L144.663,193.963L149.865,200.22z"
				},
				{
					"id":"SS-BW",
					"title":"Western Bahr el Ghazal",
					"d":"M118.96,144.033L119.704,145.194L120.244,145.535L120.049,159.231L123.252,160.141L127.837,163.07L129.721,165.866L130.862,168.668L139.402,177.121L139.402,177.121L134.062,234.77L134.662,246.847L137.43,248.602L137.141,249.465L137.614,250.893L137.209,252.931L138.223,254.222L137.943,257.024L138.096,264.083L138.475,268.474L140.142,278.474L144.231,292.366L178.373,314.096L187.789,307.837L227.012,287.957L227.472,287.3L230.595,286.31L232.774,287.099L232.774,287.099L236.859,307.882L236.271,309.757L237.002,312.92L241.004,317.116L245.66,319.826L248.467,320.889L249.942,323.062L252.042,323.13L253.337,323.939L254.476,325.337L256.268,325.188L259.949,327.292L264.274,329.257L265.491,330.815L266.843,331.831L268.127,333.729L268.745,335.861L267.654,339.756L267.857,344.768L267.316,346.731L267.249,348.966L266.573,352.147L266.775,353.298L265.626,355.059L265.221,357.427L265.427,358.742L266.348,360.601L266.525,363.107L293.24,364.059L293.368,391.7L293.368,391.7L263.159,392.067L255.788,388.428L152.772,398.605L152.772,398.605L152.423,398.222L151.367,397.955L149.071,395.711L147.253,395.598L146.12,394.756L144.115,394.798L142.67,394.359L142.316,392.664L139.52,392.191L138.914,391.771L138.995,390.714L136.853,389.154L136.651,388.89L137.041,388.16L136.235,387.319L132.66,387.172L131.977,386.595L130.69,384.54L130.931,381.167L130.683,380.887L130.138,381.336L129.5,381.397L129.003,380.743L129.146,379.842L127.669,379.745L127.685,379.294L128.62,378.41L127.955,377.024L128.563,375.673L128.565,375.066L128.192,374.646L126.98,374.178L123.933,374.218L123.544,373.875L123.796,372.771L123.408,372.18L120.127,371.832L119.755,371.52L119.694,370.711L117.751,370.241L118.593,369.061L117.413,368.126L116.48,368.124L115.642,367.438L112.531,367.184L112.174,366.919L112.922,366.049L113.063,365.069L112.613,364.587L108.089,363.926L108.075,362.899L106.582,362.71L105.975,363.207L104.671,361.604L103.956,361.369L103.474,361.663L102.292,361.553L101.592,361.147L101.111,360.369L100.022,360.383L99.043,359.868L98.172,360.069L97.736,359.882L97.598,358.746L97.085,358.403L96.446,359.242L95.778,358.914L95.904,357.764L95.065,357.187L94.455,357.638L93.449,356.158L92.905,355.939L92.593,356.11L91.816,355.813L91.566,356.56L91.053,356.591L90.618,355.983L89.995,356.48L89.59,356.464L89.342,355.811L88.67,355.217L87.928,355.528L88.069,354.238L87.852,353.957L86.918,354.189L86.064,353.131L84.634,352.164L83.638,352.754L82.861,351.634L81.726,351.368L80.795,349.204L80.936,348.24L80.036,346.916L80.068,346.139L79.197,345.78L78.279,346.074L78.062,345.234L77.393,344.782L77.021,344.113L76.476,344.05L76.742,343.49L76.212,343.194L75.949,342.509L75.59,343.038L73.459,342.725L72.62,341.914L71.267,341.851L70.862,341.586L70.551,341.072L70.832,340.403L70.663,338.396L69.965,336.699L69.079,336.123L69.172,335.47L69.795,335.236L70.091,334.661L71.555,334.227L71.805,333.418L72.987,333.356L73.331,332.657L73.891,332.424L74.653,332.627L76.771,331.431L77.052,331.089L77.068,330.622L76.695,330.201L76.851,329.828L77.629,329.892L77.925,329.643L77.957,329.16L76.868,328.443L76.76,327.836L76.263,327.431L76.7,326.373L76.327,325.626L76.81,325.175L77.138,324.194L76.705,321.767L77.08,321.035L76.893,320.537L76.551,320.271L76.13,320.723L75.368,320.551L75.338,319.664L72.851,316.673L72.929,315.925L71.746,315.971L69.491,313.54L67.296,313.787L63.621,314.843L62.471,313.036L61.288,311.883L55.407,308.064L54.361,305.793L53.412,304.813L50.954,303.461L49.799,297.626L49.083,296.958L48.178,294.717L47.399,294.5L46.902,294.951L45.952,294.018L44.146,293.988L42.403,294.627L41.188,294.504L40.346,293.212L39.723,292.793L37.201,292.936L35.814,292.065L33.463,291.616L31.767,291.837L28.157,293.149L27.175,293.104L24.604,291.832L23.746,290.759L23.077,290.838L21.872,288.288L20.938,288.46L19.428,288.246L18.851,287.857L17.729,287.922L14.84,289.906L13.357,289.566L12.607,288.572L10.023,288.952L5.691,287.593L3.491,286.338L0.098,281.863L0,280.664L0.617,278.73L0.779,275.568L1.304,274.289L2.703,273.022L5.497,269.243L7.962,267.01L6.235,265.547L5.42,264.083L5.791,262.976L7.153,260.871L14.286,254.699L23.396,250.077L24.564,248.853L26.398,245.754L27.603,245.028L28.923,243.46L29.247,241.402L27.235,234.63L28.874,226.765L30.53,220.985L32.455,217.478L31.469,214.649L31.362,212.967L37.215,208.364L40.022,206.5L41.514,203.181L41.487,200.031L40.784,197.541L40.763,191.55L39.966,189.198L40.76,188.772L41.707,187.273L43.464,182.98L44.072,182.572L45.627,182.436L46.776,181.822L48.804,180.05L52.25,177.869L53.129,176.847L54.075,175.006L55.495,173.506L57.184,168.87L58.401,167.165L59.145,165.187L59.145,163.55L58.266,161.64L58.266,159.184L59.347,157.41L59.752,155.773L60.969,154.067L62.112,151.518L62.659,151.064L66.106,149.904L67.931,150.109L70.702,149.29L71.445,149.563L72.122,149.426L72.594,149.017L73.406,148.88L75.704,149.699L79.421,149.426L80.637,148.744L83.071,148.539L84.355,147.924L86.518,147.447L90.1,147.515L99.765,144.58L101.995,144.58L104.969,143.965L108.957,144.033L109.971,143.214L114.703,142.122L117.878,143.146z"
				},
				{
					"id":"SS-EC",
					"title":"Central Equatoria",
					"d":"M415.032,436.375L430.711,436.09L436.746,425.292L464.309,448.681L477.373,447.793L501.692,450.37L509.093,454.524L509.499,453.476L509.385,451.836L510.74,451.799L510.74,451.799L538.121,452.147L538.121,452.147L536.99,495.728L541.824,512.866L541.179,523.917L545.516,536.289L542.449,539.637L537.449,541.368L535.003,543.67L535.166,558.976L530.447,565.829L530.644,569.224L529.933,569.744L529.46,571.809L527.585,571.027L524.097,572.396L520.791,574.229L514.506,574.564L511.594,577.54L516.996,588.161L517.091,588.841L517.091,588.841L516.635,589.013L516.586,589.397L517.055,589.951L516.948,590.447L513.042,593.477L511.903,593.778L510.66,595.606L501.77,598.413L499.732,600.157L498.101,600.869L497.846,601.382L496.765,600.989L497.179,598.814L493.61,597.289L486.67,593.667L482.457,590.748L474.01,590.711L473.138,591.832L471.567,592.633L470.775,593.451L469.896,593.677L469.583,594.063L469.922,594.336L469.603,594.625L469.179,594.394L468.988,594.723L468.805,594.244L467.947,594.117L467.258,594.343L466.78,594.809L467.107,595.049L466.905,595.75L464.863,597.268L464.16,597.507L463.937,597.034L462.851,596.453L461.273,597.184L460.597,598.853L459.813,599.153L459.281,600.176L459.362,601.54L458.763,602.001L458.693,602.484L457.849,602.702L457.468,603.807L456.686,604.129L456.275,605.468L455.246,606.799L453.488,611.564L454.078,611.863L453.551,612L452.952,611.613L452.446,610.137L453.397,607.56L453.524,606.452L453.181,606.063L450.297,605.321L449.286,604.614L448.368,602.58L448.246,600.164L447.402,598.945L446.299,599.499L445.685,601.428L444.908,602.336L443.854,602.583L441.684,601.682L440.371,601.522L437.338,603.505L435.268,604.356L434.008,604.503L433.018,604.239L432.859,603.543L434.117,601.2L434.794,598.573L433.756,592.369L432.604,589.076L432.687,586.573L432.204,585.93L430.432,585.86L428.582,586.693L427.218,586.518L425.313,584.849L424.646,584.718L423.611,585.237L423.048,585.004L421.414,583.213L419.11,582.791L417.347,581.699L415.489,581.698L414.507,580.413L413.753,579.994L413.105,580L410.306,581.268L409.396,580.458L408.91,579.492L409.094,577.106L408.851,576.563L407.041,574.179L405.978,573.354L405.783,570.528L403.796,569.423L400.593,569.469L398.596,567.204L397.838,564.35L394.402,561.807L391.74,561.262L391.48,560.795L392.798,558.386L392.634,557.563L391.328,555.865L388.659,553.926L388.041,553.751L386.937,554.239L384.424,554.393L383.285,553.223L381.633,552.267L381.447,547.631L382.138,543.992L381.278,542.793L381.545,542.206L383.151,540.883L383.391,539.877L382.524,539.205L382.524,539.205L386.836,536.129L391.539,533.558L394.969,533.199L399.597,533.298L408.426,529.456L410.675,529.469L415.04,530.913L422.126,536.261L423.945,535.9L429.511,532.135L430.231,529.792L430.441,525.316L430.941,523.992L431.654,523.131L433.661,522.093L441.622,519.666L449.168,514.057L452.342,513.673L454.674,509.917L455.434,505.938L454.673,504.389L455.256,498.986L453.984,494.994L455.499,482.797L461.968,482.616L462.581,471.739L439.641,459.308z"
				},
				{
					"id":"SS-EE",
					"title":"Eastern Equatoria",
					"d":"M739.663,460.472L741.642,463.674L741.398,467.884L753.494,476.248L753.766,478.854L753.421,480.217L752.839,481.039L752.469,483.907L753.485,487.297L754.549,487.533L755.82,487.28L757.489,486.299L760.677,485.462L765.62,482L767.334,481.551L768.063,481.818L769.248,481.568L772.313,481.771L777.52,484.027L783.244,484.787L784.739,485.987L786.274,486.603L787.806,486.799L788.562,487.377L789.214,487.351L789.893,488.094L790.939,488.502L791.28,489.337L790.844,490.572L789.108,492.117L788.775,492.989L788.887,494.354L789.711,496.056L790.833,496.971L791.185,498.622L790.965,499.673L789.477,501.646L788.23,502.719L787.797,503.879L787.887,510.126L786.346,527.806L790.374,533.209L792,534.821L786.774,534.885L786.202,531.751L784.982,531.143L782.947,532.156L780.835,535.111L772.646,535.051L767.689,526.682L767.377,525.643L766.12,524.711L767.196,522.555L768.307,515.229L768.619,515.35L769.521,512.484L761.586,513.499L763.011,505.79L760.772,505.588L756.907,509.036L753.449,510.862L751.142,511.249L750.937,511.028L728.382,519.225L711.022,526.22L690.72,535.023L665.079,559.828L666.813,561.169L665.746,562.156L664.785,561.274L632.8,593.526L630.953,593.589L610.111,591.923L599.901,584.192L591.346,589.442L579.116,592.658L558.506,594.151L543.765,603.916L543.608,604.124L544.569,604.486L545.168,606.355L544.52,607.316L543.968,610.206L537.365,608.521L536.139,608.471L536.068,608.062L536.454,608.14L536.415,607.391L535.985,607.423L535.921,606.72L536.244,606.48L535.902,606.526L535.893,606.126L535.319,606.031L535.154,605.395L534.61,605.379L534.639,605.133L534.279,605.029L534.516,604.809L534.014,604.678L534.014,604.384L533.554,604.66L533.407,604.281L532.697,604.91L530.091,605.401L529.12,605.298L527.607,605.837L527.74,605.377L527.172,601.98L527.759,600.705L527.563,599.919L521.639,591.519L518.573,589.125L517.091,588.841L517.091,588.841L516.996,588.161L511.594,577.54L514.506,574.564L520.791,574.229L524.097,572.396L527.585,571.027L529.46,571.809L529.933,569.744L530.644,569.224L530.447,565.829L535.166,558.976L535.003,543.67L537.449,541.368L542.449,539.637L545.516,536.289L541.179,523.917L541.824,512.866L536.99,495.728L538.121,452.147L538.121,452.147L614.352,452.566L661.406,459.814L674.973,460.97L733.189,442.688L733.189,442.688L732.361,445.343L732.31,445.951L733.017,447.354L732.586,449.321L736.327,454.576z"
				},
				{
					"id":"SS-EW",
					"title":"Western Equatoria",
					"d":"M152.772,398.605L255.788,388.428L263.159,392.067L293.368,391.7L293.368,391.7L293.771,400.817L293.591,409.003L293.591,409.003L291.428,409.182L291.632,413.104L294.03,416.571L294.089,417.344L292.106,419.283L291.758,421.876L292.063,422.957L294.808,424.571L295.299,425.283L296.526,427.973L297.957,434.676L298.661,436.685L299.584,437.582L303.813,438.275L305.414,439.978L306.765,442.574L307.806,445.663L313.099,451.82L315.254,453.863L319.914,455.174L322.875,456.355L326.265,458.896L327.124,460.656L366.434,464.205L365.549,460.687L365.804,458.065L367.67,454.277L368.734,449.776L369.98,446.448L369.861,445.183L370.67,443.396L371.968,443.061L375.498,440.418L380.392,436.174L380.858,435.157L380.465,432.687L379.666,431.388L380.666,427.841L380.741,423.766L378.936,418.449L379.34,417.276L403.524,417.216L405.36,425.058L409.017,432.351L408.256,436.399L415.032,436.375L415.032,436.375L439.641,459.308L462.581,471.739L461.968,482.616L455.499,482.797L453.984,494.994L455.256,498.986L454.673,504.389L455.434,505.938L454.674,509.917L452.342,513.673L449.168,514.057L441.622,519.666L433.661,522.093L431.654,523.131L430.941,523.992L430.441,525.316L430.231,529.792L429.511,532.135L423.945,535.9L422.126,536.261L415.04,530.913L410.675,529.469L408.426,529.456L399.597,533.298L394.969,533.199L391.539,533.558L386.836,536.129L382.524,539.205L382.524,539.205L380.666,539.13L379.605,537.82L377.631,538.63L377.229,538.379L375.527,535.562L373.655,534.991L373.13,534.522L372.294,534.315L371.462,533.504L369.79,533.106L369.22,532.56L367.912,533.42L366.444,532.465L365.25,532.644L365.066,532.208L363.557,533.082L363.123,532.986L362.88,532.179L361.37,530.634L360.416,531.854L359.965,532.114L359.159,532.063L358.877,532.433L359.254,534.265L359.137,535.598L359.561,537.182L358.189,538.32L357.376,539.416L357.268,541.788L355.298,544.52L353.851,545.363L352.47,545.557L351.878,545.987L351.33,546.991L350.536,550.041L349.397,551.165L348.356,551.593L347.658,551.543L347.026,551.027L346.437,551.07L345.479,550.6L344.329,551.042L344.755,552.424L344.265,553.848L342.278,554.409L341.503,554.28L340.489,552.88L339.377,552.207L337.483,550.072L336.679,549.727L336.717,548.502L335.138,548.137L332.905,548.201L333.101,546.591L330.885,546.345L330.345,545.908L330.319,544.947L329.996,544.589L328.31,543.896L326.909,544.865L326.009,545.063L324.088,544.819L322.597,545.214L321.746,544.915L321.093,545.345L318.805,544.217L318.025,544.956L316.179,545.163L314.588,544.039L314.389,543.619L314.797,542.815L314.526,541.264L313.249,539.474L312.675,539.486L310.885,540.903L308.838,540.954L308.247,541.23L308.136,541.757L308.553,542.038L308.068,542.733L306.625,543.144L307.16,544.511L305.376,547.317L304.842,548.809L302.421,549.385L301.85,549.025L300.779,549.159L300.108,549.869L299.917,551.03L299.091,551.848L297.341,551.575L294.563,552.213L294.466,552.848L293.549,553.433L293.56,554.223L292.907,554.669L292.775,556.141L291.688,556.662L291.031,557.853L289.666,557.985L287.926,558.768L286.581,558.218L285.401,558.507L284.908,558.009L285.146,556.863L284.829,555.219L283.996,554.408L283.813,553.524L282.758,553.845L281.598,553.297L278.854,553.531L278.25,553.249L277.208,554.066L273.676,553.662L271.933,551.794L269.009,550.541L268.933,550.106L269.73,548.73L269.547,548.079L269.022,547.704L268.339,548.011L267.396,547.371L266.897,547.927L265.874,548.047L265.776,548.93L265.17,549.407L264.075,547.012L262.831,546.503L262.245,544.899L262.414,541.846L263.009,540.546L262.917,540.174L262.453,540.001L261.429,540.338L260.236,539.867L258.423,539.658L258.019,540.028L255.978,538.81L255.365,540.436L254.638,540.184L251.181,540.169L250.253,539.515L249.537,538.471L248.802,538.358L248.746,537.68L247.734,537.52L247.304,536.665L246.123,537.125L245.473,536.858L245.273,536.579L245.696,535.542L245.622,534.735L244.946,533.104L245.076,532.004L244.738,530.979L244.756,530.421L245.595,529.99L245.783,529.557L245.715,527.479L244.271,524.17L243.621,523.795L240.735,524.14L239.933,523.035L240.448,522.371L239.143,519.063L236.933,517.037L233.149,516.898L231.72,517.436L230.885,516.781L230.238,515.739L228.906,515.176L228.027,513.621L228.048,512.489L227.586,511.417L226.378,510.993L225.699,510.061L223.688,508.471L223.228,507.29L223.268,504.87L222.774,504.217L221.752,503.731L219.929,501.693L219.302,499.426L216.825,497.787L216.162,496.668L214.379,496.273L212.834,494.329L212.284,491.938L211.093,490.94L209.32,487.675L209.108,486.309L209.887,485.35L208.712,484.026L208.257,480.936L209.969,475.541L211.186,473.962L211.237,472.611L210.869,471.523L211.679,470.533L211.65,470.129L210.039,469.224L208.824,470.182L208.576,470.01L208.471,468.954L208.069,468.533L208.554,467.418L208.527,466.331L206.873,464.524L207.203,463.33L205.225,460.653L202.296,459.184L202.203,458.95L203.135,458.752L203.572,458.35L203.34,457.961L202.44,457.601L201.586,457.722L201.308,457.271L200.608,457.424L200.55,456.243L199.773,456.66L199.512,455.712L197.912,455.955L197.366,456.684L196.669,456.138L195.938,456.415L195.644,456.104L195.725,455.188L194.375,454.872L194.035,454.374L194.226,453.226L193.575,452.494L192.289,451.822L189.708,452.528L187.664,451.031L187.557,450.239L186.814,449.445L185.152,449.533L183.924,450.197L181.829,449.492L181.21,448.745L180.896,444.815L180.279,443.556L179.69,443.104L178.928,443.365L178.48,442.695L176.912,442.35L175.719,441.368L175.145,441.288L174.336,441.814L173.559,441.858L172.505,441.11L171.107,440.982L170.002,441.817L169.179,441.924L167.83,441.159L166.82,441.126L165.828,440.237L164.119,440.466L162.77,440.012L162.23,438.427L161.346,437.942L160.84,435.409L160.343,435.16L159.988,434.46L157.795,435.324L156.409,436.78L155.71,436.903L155.4,436.468L155.357,435.318L155.936,433.906L159.359,431.6L160.981,429.119L161.094,427.736L160.536,427.083L159.899,426.973L157.94,427.775L157.397,427.37L156.841,426.25L157.05,423.531L155.142,422.719L154.459,422.033L151.71,421.607L150.904,421.171L148.13,418.149L145.042,416.076L144.749,415.718L144.781,415.112L146.12,413.701L146.246,413.235L145.222,412.472L145.753,411.214L145.428,410.825L144.853,411.149L144.278,411.024L144.998,408.896L146.753,408.916L147.003,408.622L146.571,407.657L147.617,405.779L148.551,405.098L148.757,403.404L149.084,403.125L150.716,403.16L150.703,402.072L152.198,400.941L152.635,400.118L152.964,399.202z"
				},
				{
					"id":"SS-JG",
					"title":"Jonglei",
					"d":"M443.405,359.679L442.1,358.578L441.221,355.532L439.396,353.772L439.193,353.027L439.463,350.455L438.855,348.763L436.422,346.528L435.948,344.632L434.259,344.09L434.057,343.819L434.191,342.668L432.366,341.585L431.961,340.23L433.541,340.022L433.719,337.453L432.637,335.286L431.353,334.744L430.339,333.863L430.609,332.237L430.204,331.695L428.987,331.154L428.446,330.341L428.514,329.935L429.393,329.528L429.527,329.121L429.258,327.495L429.596,325.937L429.393,324.379L429.798,323.836L430.88,323.498L431.488,322.685L431.42,321.939L430.947,321.465L432.164,320.584L432.028,320.313L430.542,320.041L431.488,319.229L431.488,318.821L429.865,318.076L429.527,315.297L428.717,314.687L428.514,313.195L427.027,310.958L426.216,310.416L425.405,308.856L424.121,308.246L424.053,307.704L424.797,307.568L424.932,307.229L421.958,303.161L421.688,302.415L421.755,300.652L421.35,299.634L420.403,299.16L419.179,299.929L418.781,298.481L417.564,299.499L417.159,299.363L416.01,296.311L416.01,293.055L417.362,292.512L417.768,291.969L417.497,291.291L416.618,291.223L416.551,290.544L418.038,289.73L418.309,289.052L418.038,288.374L416.889,287.22L417.024,286.542L418.173,286.27L418.24,285.863L417.902,283.624L416.889,280.977L418.646,279.891L418.916,278.737L419.524,278.058L419.862,275.954L419.39,275.003L417.564,274.664L417.362,272.695L416.825,272.285L415.47,272.22L414.861,270.522L413.915,270.047L413.645,269.436L413.779,268.689L414.456,267.807L414.523,266.992L414.32,266.72L413.982,266.788L413.441,267.603L413.441,266.72L414.253,265.158L414.591,263.664L416.01,262.306L416.348,261.219L415.672,260.064L413.712,259.725L412.969,258.638L411.211,257.143L410.941,256.464L410.873,255.173L412.293,253.814L412.428,252.659L412.226,252.387L411.548,252.575L411.076,252.047L410.941,248.242L410.604,247.563L409.589,246.679L409.251,245.66L409.859,243.145L408.17,240.562L408.035,239.406L408.846,237.91L409.792,237.366L411.076,237.23L411.549,235.531L412.631,235.19L413.441,233.151L414.523,233.015L415.063,232.199L416.146,231.859L416.078,229.818L417.024,227.03L419.119,226.282L418.984,224.717L420.336,223.697L420.471,222.948L420.471,222.472L419.66,221.384L419.457,220.635L419.998,219.274L419.457,217.982L418.038,217.574L417.159,214.988L417.632,214.58L419.39,214.171L420.336,211.381L421.012,210.632L422.499,209.747L422.769,208.182L423.242,207.229L426.014,205.799L426.892,204.778L427.563,205.504L428.931,204.87L429.027,203.639L431.696,204.319L432.855,204.935L435.299,204.74L438.098,205.324L442.343,205.324L445.649,207.457L445.864,204.536L446.676,204.642L446.676,204.642L449.061,204.573L450.818,205.118L452.237,204.573L455.347,205.254L458.523,204.029L460.01,204.097L463.931,205.867L465.146,206.003L466.431,207.569L471.05,210.781L500.609,222.006L508.746,221.226L509.258,222.213L509.341,226.433L510.386,227.662L512.268,231.022L513.304,231.506L513.624,232.216L513.743,234.293L514.323,235.807L515.912,238.145L515.348,240.571L515.555,242.182L517.004,243.281L518.262,246.615L519.018,247.226L519.496,248.089L519.611,249.792L521.294,252.098L525.422,255.304L529.069,258.901L536.351,250.523L547.729,244.124L549.812,240.812L550.521,240.183L565.698,245.956L573.876,276.849L592.954,287.738L586.614,308.022L600.24,308.039L600.24,308.039L600.477,308.703L599.943,309.607L598.168,311.019L598.364,311.949L598.168,312.667L598.95,314.511L598.285,314.746L598.129,315.139L598.716,316.59L601.02,319.722L601.41,321.378L601.842,321.118L602.23,321.464L603.741,321.031L603.998,320.513L605.122,321.378L604.906,321.854L605.381,321.939L605.797,321.572L607.049,321.337L607.322,321.594L608.574,321.074L608.653,320.709L609.201,320.827L612.683,322.474L614.131,322.317L617.036,324.481L617.965,324.2L618.269,324.598L618.53,325.575L619.334,325.847L619.664,326.871L621.175,326.525L621.779,325.703L622.34,325.963L623.324,325.259L624.42,325.416L627.198,323.808L628.294,324.592L629.198,324.508L629.408,324.114L631.187,325.228L632.007,325.444L632.826,325.142L634.553,327.045L637.237,328.2L637.627,327.496L638.522,326.915L639.422,327.174L640.116,326.765L641.028,327.853L643.467,327.821L644.233,328.512L644.1,329.089L644.674,329.377L644.951,330.001L646.685,330.586L647.566,331.368L647.834,332.198L650.592,333.811L651.627,333.753L654.385,336.229L656.913,339.626L658.005,340.029L659.096,339.626L662.075,340.686L661.797,341.353L661.907,343.008L662.682,343.333L662.757,344.41L664.582,345.162L667.558,349.671L667.858,350.723L667.833,356.057L667.433,356.683L666.308,356.432L666.408,357.107L668.583,359.712L670.783,360.463L671.834,361.389L672.309,362.541L674.295,362.825L675.407,364.111L676.806,364.097L678.616,365.376L678.674,370.967L680.178,371.551L681.298,373.636L682.891,373.22L687.416,376.47L689.919,377.144L691.517,377.128L693.321,377.909L698.346,381.156L700.768,383.929L701.479,385.32L701.836,391.406L703.541,392.289L707.039,392.757L708.127,391.649L711.649,394.813L713.45,395.196L713.968,397.388L716.088,400.064L718.906,402.836L720.096,401.728L722.691,401.806L723.485,401.2L725.688,401.98L725.399,403.281L726.8,403.669L727.807,404.659L729.11,405.348L730.123,407.236L730.231,408.233L732.136,409.217L733.646,410.901L734.133,412.207L733.401,415.085L732.29,416.164L732.186,422.081L729.898,424.172L729.752,425.241L730.905,428.691L731.104,431.834L730.492,433.123L730.36,434.161L730.861,436.172L732.34,437.698L732.66,438.627L732.702,441.01L733.334,442.081L733.189,442.688L733.189,442.688L674.973,460.97L661.406,459.814L614.352,452.566L538.121,452.147L538.121,452.147L510.74,451.799L510.74,451.799L508.944,449.076L508.065,446.579L507.524,446.241L506.376,446.512L505.159,444.959L502.591,437.532L501.848,436.317L499.752,434.359L499.211,433.481L498.13,428.619L497.589,427.269L496.575,425.985L496.034,422.405L495.088,420.108L493.398,418.487L492.723,416.934L490.29,413.758L489.884,412.812L489.682,410.244L488.803,408.758L488.127,408.082L486.234,407.608L485.559,406.865L485.355,404.365L484.561,403.103L484.409,400.647L483.058,399.296L482.446,397.535L480.827,395.916L480.106,393.6L479.033,392.476L476.569,390.913L476.096,389.967L475.488,389.696L475.082,388.208L473.934,387.6L473.393,386.788L471.027,385.368L469.675,383.745L468.188,383.069L467.175,380.499L464.403,379.484L462.781,378.335L460.889,377.996L458.794,375.426L456.833,374.614L456.226,373.803L455.279,373.396L453.251,373.126L452.305,372.585L451.562,370.623L450.074,369.27L449.398,366.698L447.033,365.819L445.614,363.586L443.653,362.3L443.384,361.218L443.722,360.202z"
				},
				{
					"id":"SS-LK",
					"title":"Lakes",
					"d":"M374.886,318.578L390.337,320.569L393.794,330.708L411.214,368.306L431.778,370.187L437.187,361.254L443.405,359.679L443.405,359.679L443.722,360.202L443.384,361.218L443.653,362.3L445.614,363.586L447.033,365.819L449.398,366.698L450.074,369.27L451.562,370.623L452.305,372.585L453.251,373.126L455.279,373.396L456.226,373.803L456.833,374.614L458.794,375.426L460.889,377.996L462.781,378.335L464.403,379.484L467.175,380.499L468.188,383.069L469.675,383.745L471.027,385.368L473.393,386.788L473.934,387.6L475.082,388.208L475.488,389.696L476.096,389.967L476.569,390.913L479.033,392.476L480.106,393.6L480.827,395.916L482.446,397.535L483.058,399.296L484.409,400.647L484.561,403.103L485.355,404.365L485.559,406.865L486.234,407.608L488.127,408.082L488.803,408.758L489.682,410.244L489.884,412.812L490.29,413.758L492.723,416.934L493.398,418.487L495.088,420.108L496.034,422.405L496.575,425.985L497.589,427.269L498.13,428.619L499.211,433.481L499.752,434.359L501.848,436.317L502.591,437.532L505.159,444.959L506.376,446.512L507.524,446.241L508.065,446.579L508.944,449.076L510.74,451.799L510.74,451.799L509.385,451.836L509.499,453.476L509.093,454.524L501.692,450.37L477.373,447.793L464.309,448.681L436.746,425.292L430.711,436.09L415.032,436.375L415.032,436.375L408.256,436.399L409.017,432.351L405.36,425.058L403.524,417.216L379.34,417.276L378.936,418.449L380.741,423.766L380.666,427.841L379.666,431.388L380.465,432.687L380.858,435.157L380.392,436.174L375.498,440.418L371.968,443.061L370.67,443.396L369.861,445.183L369.98,446.448L368.734,449.776L367.67,454.277L365.804,458.065L365.549,460.687L366.434,464.205L327.124,460.656L326.265,458.896L322.875,456.355L319.914,455.174L315.254,453.863L313.099,451.82L307.806,445.663L306.765,442.574L305.414,439.978L303.813,438.275L299.584,437.582L298.661,436.685L297.957,434.676L296.526,427.973L295.299,425.283L294.808,424.571L292.063,422.957L291.758,421.876L292.106,419.283L294.089,417.344L294.03,416.571L291.632,413.104L291.428,409.182L293.591,409.003L293.591,409.003L313.121,415.953L320.382,414.988L324.319,410.615L326.99,406.176L327.229,398.978L326.296,391.219L318.699,371.656L330.287,350.719L359.677,316.599z"
				},
				{
					"id":"SS-NU",
					"title":"Upper Nile",
					"d":"M579.371,19.116L615.277,20.338L618.709,20.227L615.609,24.028L613.646,35.266L611.37,51.84L607.38,62.745L618.717,115.301L614.715,122.49L630.383,127.634L642.924,142.566L651.076,148.293L657.518,159.612L662.356,159.647L663.452,162.528L663.137,164.773L664.22,169.21L664.634,169.889L664.43,173.687L664.799,175.797L662.415,185.217L659.99,188.697L657.7,195.469L657.494,199.045L658.255,202.578L658.297,206.087L672.653,205.886L673.863,221.593L674.716,227.387L675.395,241.633L675.117,245.118L675.042,254.622L675.379,261.506L675.218,265.502L673.803,267.938L672.13,269.64L671.108,269.723L670.378,270.175L667.851,272.33L666.994,273.799L666.629,273.927L665.648,273.518L665.035,273.855L663.735,273.146L662.66,273.55L661.97,273.189L660.565,273.927L658.74,274.354L658.103,275.595L657.605,275.733L657.605,276.205L657.164,276.731L657.315,277.355L654.816,277.729L653.934,278.45L653.022,279.836L652.057,280.224L650.234,281.888L648.675,281.527L647.888,282.165L647.06,282.275L645.375,281.693L644.188,279.42L643.843,277.799L643.995,277.064L639.933,275.168L638.404,276.67L636.949,276.611L636.005,275.19L631.693,275.007L631.085,275.142L630.653,275.975L629.159,276.473L628.295,277.271L626.67,276.67L624.748,278.225L623.747,277.671L623.199,277.723L622.824,277.038L621.65,276.77L620.655,276.882L619.685,276.496L619.24,275.787L618.655,276.064L618.01,277.331L617.553,277.347L616.58,276.251L614.825,276.837L614.705,277.422L613.846,278.276L612.707,277.623L612.656,279.278L611.047,279.355L610.854,279.702L611.208,280.382L610.809,281.185L611.096,283.134L611.558,283.241L612.657,282.859L612.542,283.763L612.257,284.244L611.002,284.378L611.657,286.2L611.208,286.752L609.515,286.883L609.908,287.705L609.892,289.695L610.205,290.132L611.422,290.166L611.719,291.098L610.908,292.67L609.233,293.759L609.321,294.226L609.695,294.202L609.984,295.682L610.471,296.092L610.458,297.132L610.823,297.836L610.61,298.579L609.706,298.333L608.753,299.456L607.25,299.344L606.138,299.717L605.921,300.149L606.043,302.699L605.091,301.84L603.82,301.866L603.885,302.815L603.354,303.31L603.263,305.287L602.002,305.996L601.151,305.971L600.484,306.625L600.085,307.604L600.24,308.039L600.24,308.039L586.614,308.022L592.954,287.738L573.876,276.849L565.698,245.956L550.521,240.183L549.812,240.812L547.729,244.124L536.351,250.523L529.069,258.901L525.422,255.304L521.294,252.098L519.611,249.792L519.496,248.089L519.018,247.226L518.262,246.615L517.004,243.281L515.555,242.182L515.348,240.571L515.912,238.145L514.323,235.807L513.743,234.293L513.624,232.216L513.304,231.506L512.268,231.022L510.386,227.662L509.341,226.433L509.258,222.213L508.746,221.226L500.609,222.006L471.05,210.781L466.431,207.569L465.484,206.208L464.809,205.867L463.931,205.867L460.01,204.097L458.523,204.029L455.347,205.254L452.237,204.573L450.818,205.118L449.061,204.573L446.676,204.642L446.676,204.642L447.898,188.122L448.601,188.122L448.601,188.122L451.444,190.662L456.381,188.458L481.009,188.475L484.615,187.344L486.416,186.452L499.882,169.403L517.097,150.023L519.952,146.096L530.223,127.993L541.313,121.063L562.389,100.78L558.502,94.239L557.225,89.227L557.004,55.186L542.222,40.652L579.371,40.61L579.235,37.728L580.857,34.501L581.105,31.813L579.642,26.742L579.438,23.719L579.776,20.284z"
				},
				{
					"id":"SS-UY",
					"title":"Unity",
					"d":"M389.433,150.904L391.333,151.365L395.042,151.283L424.711,169.699L435.975,176.171L448.85,188.123L448.601,188.122L448.601,188.122L447.898,188.122L446.676,204.642L446.676,204.642L445.864,204.536L445.649,207.457L442.343,205.324L438.098,205.324L435.299,204.74L432.855,204.935L431.696,204.319L429.027,203.639L428.931,204.87L427.563,205.504L426.892,204.778L426.014,205.799L423.242,207.229L422.769,208.182L422.499,209.747L421.012,210.632L420.336,211.381L419.39,214.171L417.632,214.58L417.159,214.988L418.038,217.574L419.457,217.982L419.998,219.274L419.457,220.635L419.66,221.384L420.471,222.472L420.471,222.948L420.336,223.697L418.984,224.717L419.119,226.282L417.024,227.03L416.078,229.818L416.146,231.859L415.063,232.199L414.523,233.015L413.441,233.151L412.631,235.19L411.549,235.531L411.076,237.23L409.792,237.366L408.846,237.91L408.035,239.406L408.17,240.562L409.859,243.145L409.251,245.66L409.589,246.679L410.604,247.563L410.941,248.242L411.076,252.047L411.548,252.575L412.226,252.387L412.428,252.659L412.293,253.814L410.873,255.173L410.941,256.464L411.211,257.143L412.969,258.638L413.712,259.725L415.672,260.064L416.348,261.219L416.01,262.306L414.591,263.664L414.253,265.158L413.441,266.72L413.441,267.603L413.982,266.788L414.32,266.72L414.523,266.992L414.456,267.807L413.779,268.689L413.645,269.436L413.915,270.047L414.861,270.522L415.47,272.22L416.825,272.285L417.362,272.695L417.564,274.664L419.39,275.003L419.862,275.954L419.524,278.058L418.916,278.737L418.646,279.891L416.889,280.977L417.902,283.624L418.24,285.863L418.173,286.27L417.024,286.542L416.889,287.22L418.038,288.374L418.309,289.052L418.038,289.73L416.551,290.544L416.618,291.223L417.497,291.291L417.768,291.969L417.362,292.512L416.01,293.055L416.01,296.311L417.159,299.363L417.564,299.499L418.781,298.481L419.179,299.929L420.403,299.16L421.35,299.634L421.755,300.652L421.688,302.415L421.958,303.161L424.932,307.229L424.797,307.568L424.053,307.704L424.121,308.246L425.405,308.856L426.216,310.416L427.027,310.958L428.514,313.195L428.717,314.687L429.527,315.297L429.865,318.076L431.488,318.821L431.488,319.229L430.542,320.041L432.028,320.313L432.164,320.584L430.947,321.465L431.42,321.939L431.488,322.685L430.88,323.498L429.798,323.836L429.393,324.379L429.596,325.937L429.258,327.495L429.527,329.121L429.393,329.528L428.514,329.935L428.446,330.341L428.987,331.154L430.204,331.695L430.609,332.237L430.339,333.863L431.353,334.744L432.637,335.286L433.719,337.453L433.541,340.022L431.961,340.23L432.366,341.585L434.191,342.668L434.057,343.819L434.259,344.09L435.948,344.632L436.422,346.528L438.855,348.763L439.463,350.455L439.193,353.027L439.396,353.772L441.221,355.532L442.1,358.578L443.405,359.679L443.405,359.679L437.187,361.254L431.778,370.187L411.214,368.306L393.794,330.708L390.337,320.569L374.886,318.578L374.886,318.578L374.376,309.806L371.701,279.564L347.428,263.132L334.093,237.094L307.764,237.236L307.764,237.236L307.53,236.548L311.255,233.339L312.958,232.981L313.881,232.07L312.403,229.777L313.463,226.746L317.972,224.339L319.557,224.762L323.389,219.431L320.722,215.837L312.907,212.413L310.644,212.557L310.644,212.557L313.699,207.137L322.719,199.074L328.336,192.099L329.16,190.5L332.253,189.444L362.956,188.836L362.844,166.237L387.036,153.613z"
				},
				{
					"id":"SS-WR",
					"title":"Warrap",
					"d":"M307.764,237.236L334.093,237.094L347.428,263.132L371.701,279.564L374.376,309.806L374.886,318.578L374.886,318.578L359.677,316.599L330.287,350.719L318.699,371.656L326.296,391.219L327.229,398.978L326.99,406.176L324.319,410.615L320.382,414.988L313.121,415.953L293.591,409.003L293.591,409.003L293.771,400.817L293.368,391.7L293.368,391.7L293.24,364.059L266.525,363.107L266.348,360.601L265.427,358.742L265.221,357.427L265.626,355.059L266.775,353.298L266.573,352.147L267.249,348.966L267.316,346.731L267.857,344.768L267.654,339.756L268.745,335.861L268.127,333.729L266.843,331.831L265.491,330.815L264.274,329.257L259.949,327.292L256.268,325.188L254.476,325.337L253.337,323.939L252.042,323.13L249.942,323.062L248.467,320.889L245.66,319.826L241.004,317.116L237.002,312.92L236.271,309.757L236.859,307.882L232.774,287.099L232.774,287.099L236.383,285.132L234.219,281.681L229.346,277.531L227.545,269.017L225.776,265.673L228.172,265.576L228.688,265.931L230.279,266.142L233.592,267.272L235.346,265.592L235.988,265.381L237.05,263.637L237.114,262.603L236.52,261.616L238.11,259.715L236.116,258.325L235.698,256.983L234.105,255.14L233.446,252.521L232.416,251.051L232.127,247.688L231.387,246.927L232.336,246.426L233.703,246.296L233.896,245.229L234.652,244.922L235.987,243.563L238.351,243.482L239.396,242.674L241.825,243.111L242.082,242.447L244.474,242.293L243.838,243.638L244.133,243.756L245.485,241.785L246.161,241.853L247.107,242.737L247.851,242.805L248.662,241.173L249.676,241.445L250.216,242.329L251.027,241.717L251.298,241.853L251.771,242.805L252.745,243.381L253.934,242.873L256.299,242.737L257.448,243.077L258.935,241.853L260.49,243.213L261.166,243.145L261.841,241.785L262.382,241.377L264.41,242.193L265.221,244.028L265.897,243.96L267.249,242.533L267.924,242.397L268.668,243.484L269.344,243.621L271.845,242.601L272.453,243.009L273.534,242.805L274.345,241.717L275.021,241.921L275.629,243.145L276.905,243.564L279.048,242.896L283.87,239.792L285.994,238.961L288.126,239.298L290.378,240.217L293.049,240.005L298.416,237.52L299.93,238.171L302.256,238.623L305.663,238.368z"
				}
			]
		}
	}
};