﻿// (c) ammap.com | SVG (in JSON format) map of Sudan - Low
// areas: {id:"SD-DE"},{id:"SD-DC"},{id:"SD-DN"},{id:"SD-DS"},{id:"SD-DW"},{id:"SD-GD"},{id:"SD-GK"},{id:"SD-GZ"},{id:"SD-KA"},{id:"SD-KH"},{id:"SD-KN"},{id:"SD-KS"},{id:"SD-NB"},{id:"SD-NO"},{id:"SD-NR"},{id:"SD-NW"},{id:"SD-RS"},{id:"SD-SI"}
AmCharts.maps.sudanLow={
	"svg": {
		"defs": {
			"amcharts:ammap": {
				"projection":"mercator",
				"leftLongitude":"21.838566",
				"topLatitude":"23.146564",
				"rightLongitude":"38.584046",
				"bottomLatitude":"8.675690"
			}
		},
		"g":{
			"path":[
				{
					"id":"SD-DE",
					"title":"East Darfur",
					"d":"M135.787,435.367L138.529,434.828L139.861,435.608L143.148,435.449L147.292,435.822L148.165,435.362L149.324,435.398L150.372,436.217L152.557,436.099L152.766,436.365L152.524,439.058L153.116,440.24L158.822,443.015L160.231,444.194L163.576,444.321L173.158,455.8L173.292,456.448L173.201,458.334L172.898,458.907L169.914,458.569L168.947,459.448L168.225,459.717L166.419,459.263L165.337,460.294L165.11,460.732L167.778,464.289L168.068,466.459L169.799,467.388L171.167,467.461L171.037,468.566L172.449,471.57L176.385,472.799L176.539,473.617L177.757,474.661L177.664,475.745L183.889,480.157L192.795,481.39L196.381,482.402L200.789,485.343L202.048,485.882L203.34,485.814L206.14,484.728L210.178,483.819L214.673,483.875L216.888,484.444L219.96,486.771L219.96,486.771L221.528,508.23L223.873,517.504L247.353,574.049L247.353,574.049L242.824,574.502L237.256,573.854L222.401,573.454L215.661,573.813L211.697,574.602L199.187,579.021L196.02,578.785L184.884,575.378L181.743,571.6L178.566,561.431L173.41,556.327L172.721,554.635L171.583,552.946L168.815,551.178L166.881,550.629L166.999,542.359L165.978,541.122L163.653,540.298L163.653,540.298L162.37,528.892L160.354,520.892L156.241,508.512L152.241,502.808L156.944,500.854L158.506,497.794L149.057,493.083L136.208,483.359L127.295,475.167L127.444,468.713L142.733,467.31L144.785,466.06L146.131,464.36L145.953,462.171z"
				},
				{
					"id":"SD-DC",
					"title":"Central Darfur",
					"d":"M57.819,415.263L60.819,414.281L65.486,410.565L67.069,410.372L68.6,411.496L69.19,411.482L71.121,412.687L71.432,412.079L72.824,411.883L74.494,412.492L74.538,413.868L74.029,415.143L74.25,415.871L73.742,417.165L74.558,417.459L75.488,417.698L76.296,416.942L76.293,413.504L78.091,414.631L78.721,416.356L80.383,417.768L83.854,417.288L87.641,417.613L88.951,417.23L89.846,417.879L88.124,418.84L90.248,419.618L90.497,420.421L93.277,423.341L94.434,422.191L99.357,422.507L100.053,418.968L109.132,416.48L111.831,416.647L116.751,416.141L117.933,417.592L114.088,424.255L111.981,425.501L110.578,426.842L109.438,427.284L107.861,427.306L106.133,428.036L106.133,428.036L104.655,430.026L104.263,433.694L102.939,436.771L98.771,442.755L94.238,447.361L99.198,457.132L100.912,458.786L101.892,464.231L101.462,467.793L100.17,467.776L99.255,466.636L94.62,467.141L93.823,468.018L90.501,469.585L90.502,470.385L89.688,471.795L89.04,470.844L88.167,471.094L85.893,471.039L86.262,472.126L85.156,472.305L82.529,473.987L81.289,474.183L80.667,475.335L79.031,476.021L77.454,478.465L77.33,481.815L76.064,489.388L77.256,498.394L70.769,506.929L68.155,508.528L48.319,528.555L48.319,528.555L47.321,527.852L46.413,525.647L44.18,522.836L44.146,522.163L42.701,520.836L42.373,519.898L46.815,508.24L46.652,504.249L45.478,503.593L45.15,499.24L38.772,499.822L38.722,498.367L37.352,496.847L33.595,495.175L29.675,490.822L29.209,487.781L32.653,473.128L32.487,472.71L31.508,473.015L29.464,472.936L29.464,472.936L32.2,471.116L32.557,469.714L33.863,468.605L34.299,467.033L34.779,466.639L35.385,465.125L36.502,463.844L35.224,460.407L34.302,459.276L34.52,454.771L33.607,452.763L33.413,451.295L32.567,450.125L31.678,447.718L31.705,447.032L40.105,439.462L41.128,438.138L41.646,437.839L42.367,438.132L42.873,437.031L42.464,435.998L42.516,434.74L45.982,431.059L44.856,429.406L44.975,428.969L48.132,425.644L48.84,423.514L52.895,423.746L54.381,421.796L55.652,418.602L55.742,417.266z"
				},
				{
					"id":"SD-DN",
					"title":"North Darfur",
					"d":"M129.004,137.091L231.03,137.246L231.03,283.645L231.03,283.645L208.034,283.711L210.437,309.217L214.848,348.875L216.345,356.77L219.257,358.824L228.702,387.574L228.702,387.574L230.748,393.613L229.208,402.816L230.598,404.423L232.124,407.235L232.15,410.815L231.3,413.133L231.434,413.535L226.391,419.725L226.19,423.95L225.395,425.232L225.283,426.36L225.722,426.856L216.659,437.534L215.814,442.556L215.749,448.012L216.153,450.356L215.777,452.893L212.672,458.217L212.238,459.761L212.698,461.76L213.461,463.187L213.865,465.604L213.287,470.936L214.355,473.293L215.442,474.852L219.96,486.771L219.96,486.771L216.888,484.444L214.673,483.875L210.178,483.819L206.14,484.728L203.34,485.814L202.048,485.882L200.789,485.343L196.381,482.402L192.795,481.39L183.889,480.157L177.664,475.745L177.757,474.661L176.539,473.617L176.385,472.799L172.449,471.57L171.037,468.566L171.167,467.461L169.799,467.388L168.068,466.459L167.778,464.289L165.11,460.732L165.337,460.294L166.419,459.263L168.225,459.717L168.947,459.448L169.914,458.569L172.898,458.907L173.201,458.334L173.292,456.448L173.158,455.8L163.576,444.321L160.231,444.194L158.822,443.015L153.116,440.24L152.524,439.058L152.766,436.365L152.557,436.099L150.372,436.217L149.324,435.398L148.165,435.362L147.292,435.822L143.148,435.449L139.861,435.608L138.529,434.828L135.787,435.367L135.787,435.367L132.584,436.33L130.113,436.335L128.745,435.994L126.403,434.013L122.981,433.484L121.115,431.292L119.459,430.226L117.73,430.478L114.518,429.7L113.739,429.97L109.536,428.641L107.218,428.607L106.133,428.036L106.133,428.036L107.861,427.306L109.438,427.284L110.578,426.842L111.981,425.501L114.088,424.255L117.933,417.592L116.751,416.141L111.831,416.647L109.132,416.48L100.053,418.968L99.357,422.507L94.434,422.191L93.277,423.341L90.497,420.421L90.248,419.618L88.124,418.84L89.846,417.879L88.951,417.23L87.641,417.613L83.854,417.288L80.383,417.768L78.721,416.356L78.091,414.631L76.293,413.504L76.296,416.942L75.488,417.698L74.558,417.459L73.742,417.165L74.25,415.871L74.029,415.143L74.538,413.868L74.494,412.492L72.824,411.883L71.432,412.079L71.121,412.687L69.19,411.482L68.6,411.496L67.069,410.372L65.486,410.565L60.819,414.281L57.819,415.263L57.819,415.263L58.054,409.094L60.661,407.477L58.788,406.234L57.759,404.35L56.434,401.754L56.602,400.188L55.97,398.727L55.928,395.282L56.563,392.877L56.685,390.197L57.916,387.146L57.11,385.911L55.609,385.474L54.377,386.764L50.867,383.586L52.596,378.39L47.59,368.727L42.588,371.803L39.535,368.585L39.11,365.395L39.961,366.018L42.131,354.935L39.4,351.946L37.328,351.407L37.328,351.407L39.799,348.742L41.351,347.679L42.106,346.489L43.011,346.013L44.159,346.056L44.937,345.464L44.597,343.016L46.376,341.735L47.257,340.256L46.845,338.911L47.54,337.015L47.019,335.668L47.258,333.234L46.981,332.498L44.538,330.424L44.205,329.44L44.369,327.258L45.521,325.649L46.95,325.565L47.576,325.196L48.847,324.003L49.739,322.347L50.869,321.866L52.374,320.122L53.648,320.027L55.483,320.366L56.146,320.174L56.633,320.5L58.552,320.821L61.773,321.115L64.394,320.825L68.391,318.972L70.977,318.272L74.398,318.109L76.981,318.629L80.27,318.739L86.721,320.374L88.263,320.333L88.193,137.246z"
				},
				{
					"id":"SD-DS",
					"title":"South Darfur",
					"d":"M106.133,428.036L107.218,428.607L109.536,428.641L113.739,429.97L114.518,429.7L117.73,430.478L119.459,430.226L121.115,431.292L122.981,433.484L126.403,434.013L128.745,435.994L130.113,436.335L132.584,436.33L135.787,435.367L135.787,435.367L145.953,462.171L146.131,464.36L144.785,466.06L142.733,467.31L127.444,468.713L127.295,475.167L136.208,483.359L149.057,493.083L158.506,497.794L156.944,500.854L152.241,502.808L156.241,508.512L160.354,520.892L162.37,528.892L163.653,540.298L163.653,540.298L160.795,540.958L160.183,541.452L157.775,541.411L154.633,541.782L148.797,543.555L146.634,543.514L144.553,544.173L143.083,544.296L142.349,544.708L140.104,544.873L138.717,544.379L135.411,545.12L134.309,544.997L131.898,545.971L129.575,550.601L129.575,552.083L130.106,553.236L130.106,554.225L128.922,556.448L127.902,559.248L125.943,561.883L122.638,564.27L120.638,564.969L119.577,567.562L118.526,568.724L119.007,570.144L119.019,573.761L119.444,575.264L119.46,577.166L118.56,579.17L113.33,583.075L113.99,585.799L112.828,587.917L110.838,596.155L112.053,600.244L111.858,601.487L110.333,602.872L108.521,605.482L103.02,608.273L98.713,612L98.845,611.018L98.212,610.615L96.596,611.627L94.907,610.822L93.572,611.457L89.727,610.735L87.967,610.816L86.89,610.124L85.769,609.911L83.03,610.469L80.766,609.631L79.345,609.787L77.54,610.482L75.004,610.108L73.079,609.317L72.203,609.331L70.951,609.479L70.137,610.481L68.609,610.037L68.597,608.729L68.124,608.197L68.137,606.433L68.36,605.97L69.684,605.125L71.095,602.828L71.409,601.535L71.31,598.943L70.629,598.495L69.064,600.332L67.915,600.394L66.383,599.602L66.293,598.641L65.658,598.135L66.34,596.962L66.288,596.104L66.771,594.961L66.821,593.005L67.381,592.676L67.461,591.741L68.008,591.72L68.176,591.445L68.914,591.696L69.658,591.541L72.316,589.367L72.697,588.186L73.195,587.684L73.959,587.623L74.126,587.104L73.486,585.54L73.465,584.736L73.944,582.649L74.47,582.138L75.03,580.813L74.639,580.069L73.659,580.526L73.238,579.367L73.56,577.647L74.141,576.795L73.034,576.563L75.863,571.398L74.654,562.19L59.703,538.169L58.15,537.346L57.232,536.024L55.928,535.246L55.181,534.18L53.894,533.116L52.687,531.352L48.319,528.555L48.319,528.555L68.155,508.528L70.769,506.929L77.256,498.394L76.064,489.388L77.33,481.815L77.454,478.465L79.031,476.021L80.667,475.335L81.289,474.183L82.529,473.987L85.156,472.305L86.262,472.126L85.893,471.039L88.167,471.094L89.04,470.844L89.688,471.795L90.502,470.385L90.501,469.585L93.823,468.018L94.62,467.141L99.255,466.636L100.17,467.776L101.462,467.793L101.892,464.231L100.912,458.786L99.198,457.132L94.238,447.361L98.771,442.755L102.939,436.771L104.263,433.694L104.655,430.026z"
				},
				{
					"id":"SD-DW",
					"title":"West Darfur",
					"d":"M37.328,351.407L39.4,351.946L42.131,354.935L39.961,366.018L39.11,365.395L39.535,368.585L42.588,371.803L47.59,368.727L52.596,378.39L50.867,383.586L54.377,386.764L55.609,385.474L57.11,385.911L57.916,387.146L56.685,390.197L56.563,392.877L55.928,395.282L55.97,398.727L56.602,400.188L56.434,401.754L57.759,404.35L58.788,406.234L60.661,407.477L58.054,409.094L57.819,415.263L57.819,415.263L55.742,417.266L55.652,418.602L54.381,421.796L52.895,423.746L48.84,423.514L48.132,425.644L44.975,428.969L44.856,429.406L45.982,431.059L42.516,434.74L42.464,435.998L42.873,437.031L42.367,438.132L41.646,437.839L41.128,438.138L40.105,439.462L31.705,447.032L31.678,447.718L32.567,450.125L33.413,451.295L33.607,452.763L34.52,454.771L34.302,459.276L35.224,460.407L36.502,463.844L35.385,465.125L34.779,466.639L34.299,467.033L33.863,468.605L32.557,469.714L32.2,471.116L29.464,472.936L29.464,472.936L28.25,473.243L26.638,474.259L25.807,474.306L25.233,474.014L25.814,473.876L26.516,471.774L26.67,468.951L26.413,467.551L25.979,466.002L24.69,463.825L23.665,460.146L23.791,459.019L22.646,457.67L22.005,457.531L21.744,457.122L23.719,453.984L25.279,449.204L21.241,447.656L14.648,443.966L14.533,445.764L13.287,446.932L12.133,447.47L7.913,448.661L4.168,448.73L1.994,446.614L1.687,445.672L1.099,445.239L0.025,441.539L0.591,438.496L1.623,436.725L2.437,434.334L3.75,432.809L3.839,432.085L3.539,431.622L4.422,430.744L5.139,430.547L6.708,429.3L7.127,427.899L9.5,427.613L9.944,426.911L12.068,426.589L12.551,425.549L13.606,424.616L14.091,423.366L15.611,422.116L15.977,421.355L18.171,419.01L17.939,417.306L17.167,416.631L16.697,416.566L16.296,415.391L15.592,414.754L15.416,412.396L15.628,410.695L15.295,409.971L13.514,408.73L13.134,407.86L12.538,407.664L11.318,405.017L11.855,403.736L11.629,403.038L10.658,402.203L10.278,401.66L10.336,401.217L12.666,397.874L15.127,395.379L16.035,394.067L18.479,392.921L19.964,391.408L21.201,391.137L22.6,389.779L24.164,389.732L27.129,387.288L28.461,386.911L30.092,384.505L30.205,384.158L29.158,383.129L29.352,382.263L27.664,381.672L26.131,382.167L24.188,379.984L24.084,379.216L24.34,378.8L25.42,378.107L25.159,376.946L24.675,376.586L24.84,371.68L23.309,370.722L22.252,370.665L23.352,366.932L24.18,366.876L24.648,366.544L25.177,366.472L26.243,365.762L31.764,364.651L35.842,363.135L35.602,360.952L33.959,356.328L34.527,355.239L35.303,354.57L37.469,354.059L37.563,353.451L37.182,352.624z"
				},
				{
					"id":"SD-GD",
					"title":"Al Qaḑārif",
					"d":"M503.792,319.216L504.313,319.906L507.119,322.053L509.217,322.554L511.197,324.838L515.956,325.76L518.248,326.061L518.946,325.9L524.986,329.046L525.045,330.908L524.598,334.592L524.151,335.132L529.454,338.475L530.871,338.654L537.028,342.135L539.844,349.83L542.951,353.985L563.366,352.691L565.815,346.961L565.977,344.935L568.186,343.905L569.291,341.488L569.448,340.548L568.355,338.048L567.387,336.752L567.429,336.029L567.963,335.446L568.41,336.491L570.287,338.257L571.634,341.536L572.817,342.082L573.92,343.805L574.817,344.099L576.45,346.493L577.052,348.126L579.756,350.807L581.381,350.693L582.319,348.711L583.256,348.731L586.45,346.943L595.907,343.839L595.907,343.839L597.025,352.201L597.181,356.045L599.422,378.102L600.297,380.649L600.808,380.729L600.844,380.97L600.082,381.386L599.978,383.586L596.807,393.082L598.286,398.27L596.1,401.724L594.342,406.763L593.482,410.856L589.417,417.91L586.03,430.672L584.333,435.115L584.165,436.346L585.226,437.914L585.308,438.84L585.103,442.824L584.299,445.781L584.337,446.606L582.324,446.639L581.856,445.71L580.004,445.135L578.255,445.313L577.984,445.711L568.63,447.691L568.193,447.342L567.623,447.825L566.534,447.285L565.57,447.475L565.57,447.475L563.804,446.535L561.684,445.954L560.076,444.628L557.798,445.345L556.885,445.14L555.902,445.381L550.455,444.349L549.384,443.056L547.782,442.051L546.755,441.808L546.409,441.159L544.906,440.88L543.872,439.356L542.325,437.893L541.526,437.782L540.312,438.094L537.602,435.871L536.767,436.295L535.757,435.842L535.448,434.849L534.364,434.683L532.304,433.163L532.415,432.589L532.032,432.056L529.363,430.48L529.609,429.479L528.765,428.591L528.799,427.73L528.492,427.157L527.959,427.084L527.424,426.417L526.358,426.153L525.789,426.386L525.445,426.082L522.671,426.42L521.578,424.513L521.785,423.957L520.663,423.866L520.09,423.275L519.349,423.299L511.072,413.861L507.96,406.96L510.806,405.72L510.168,403.326L508.153,403.527L507.277,403.225L506.347,403.459L504.937,402.775L504.707,402.374L502.902,402.728L501.91,401.927L501.161,400.281L500.533,400.15L499.593,398.391L498.99,395.63L497.504,394.927L496.338,393.359L496.338,393.359L495.781,392.286L495.836,391.691L494.921,391.254L494.686,389.738L493.901,388.629L493.744,387.727L493.191,387.211L493.604,386.172L493.372,385.27L499.973,375.427L499.796,374.984L507.551,363.742L508.472,361.068L505.309,355.286L496.96,342.235L484.158,337.838L481.648,337.792L481.019,333.353L479.586,331.832L478.139,331.24L478.139,331.24L478.435,329.5L480.078,327.191L480.86,323.803L483.416,321.45L484.199,322.143L484.958,321.945L485.277,321.035L491.619,319.34L493.235,319.39L496.099,317.712z"
				},
				{
					"id":"SD-GK",
					"title":"West Kurdufān",
					"d":"M228.702,387.574L242.916,387.2L254.835,388.979L257.554,389.761L273.702,396.401L275.754,396.819L277.184,398.561L286.742,398.062L286.67,400.63L297.497,407.064L301.439,411.632L303.551,412.546L302.716,413.332L307.605,415.714L313.366,417.233L314.873,429.466L323.644,443.901L323.644,443.901L317.89,455.66L314.588,458.105L313.186,459.957L312.448,461.634L312.643,463.805L311.66,466.357L310.542,467.999L307.962,470.383L304.57,475.413L302.028,477.518L301.672,481.925L300.408,483.094L300.081,484.292L300.193,486.454L301.912,488.203L304.983,488.139L309.675,498.165L310.227,503.636L310.741,504.541L310.609,506.72L305.791,510.605L304.996,511.824L304.493,514.252L306.116,517.946L322.298,533.443L325.84,538.136L329.537,545.601L329.537,545.601L328.09,547.236L313.482,554.859L313.55,568.504L295.011,568.871L293.144,569.51L289.255,574.687L283.809,579.555L281.963,582.828L282.413,584.988L252.822,585.093L247.353,574.049L247.353,574.049L223.873,517.504L221.528,508.23L219.96,486.771L219.96,486.771L215.442,474.852L214.355,473.293L213.287,470.936L213.865,465.604L213.461,463.187L212.698,461.76L212.238,459.761L212.672,458.217L215.777,452.893L216.153,450.356L215.749,448.012L215.814,442.556L216.659,437.534L225.722,426.856L225.283,426.36L225.395,425.232L226.19,423.95L226.391,419.725L231.434,413.535L231.3,413.133L232.15,410.815L232.124,407.235L230.598,404.423L229.208,402.816L230.748,393.613z"
				},
				{
					"id":"SD-GZ",
					"title":"Al Jazīrah",
					"d":"M478.139,331.24L479.586,331.832L481.019,333.353L481.648,337.792L484.158,337.838L496.96,342.235L505.309,355.286L508.472,361.068L507.551,363.742L499.796,374.984L499.973,375.427L493.372,385.27L493.604,386.172L493.191,387.211L493.744,387.727L493.901,388.629L494.686,389.738L494.921,391.254L495.836,391.691L495.781,392.286L496.338,393.359L496.338,393.359L485.408,389.802L484.992,388.152L482.504,387.711L482.463,389.318L482.096,389.82L480.603,390.095L480.464,390.447L481.565,392.746L480.994,393.331L479.933,393.331L479.28,393.749L480.668,395.211L480.636,396.686L476.316,396.909L474.575,398.644L473.418,399.052L472.618,398.711L472.329,398.002L474.074,397.111L474.204,396.555L469.888,396.287L469.292,391.411L466.99,390.523L465.998,389.837L465.162,389.822L464.594,390.286L463.793,389.828L462.938,389.909L461.04,390.571L460.526,390.516L460.635,389.325L458.64,389.412L458.194,391.833L457.687,393.025L458.07,397.821L459.735,400.153L457.854,400.604L456.451,401.301L454.804,402.689L453.884,405.07L454.491,408.959L454.491,408.959L444.835,409.216L443.827,405.215L444.732,403.601L444.612,402.354L442.808,398.565L443.008,396.607L440.766,396.772L440.017,395.394L439.277,395.724L438.019,394.789L438.558,392.272L437.23,388.899L437.321,388.131L438.271,387.935L437.603,387.285L438.029,385.035L435.65,384.336L434.836,385.069L434.033,384.19L435.734,381.991L438.357,381.921L438.762,382.957L439.273,382.743L438.49,380.277L437.283,379.889L436.896,378.43L438.457,378.884L438.797,378.479L438.509,377.846L439.031,375.632L440.317,374.376L438.564,373.422L436.843,375.123L435.126,373.861L436.185,372.702L435.44,372.129L434.399,373.115L432.816,372.064L433.117,371.255L432.773,370.872L434.512,368.728L438.661,369.689L439.396,368.377L442.476,368.228L443.65,367.472L446.33,367.324L446.827,367.88L447.396,367.569L448.177,367.758L448.724,366.87L446.257,363.744L445.905,361.781L447.424,361.254L448.787,360.168L448.27,359.266L449.352,358.952L450.403,360.18L450.673,360.93L451.206,361.081L451.559,359.153L450.832,358.271L450.715,357.616L449.871,356.967L449.383,357.392L448.734,357.028L447.749,357.63L444.965,355.736L444.319,356.048L442.375,354.823L443.32,353.836L440.173,351.364L441.817,349.447L442.041,348.501L445.895,351.375L446.698,348.439L446.448,347.688L445.396,346.401L445.046,344.705L442.988,343.673L442.453,343L440.932,342.969L440.758,342.468L439.064,342.051L438.721,341.725L437.646,342.135L434.307,340.275L434.307,340.275L437.339,340.581L456.549,338.846L461.464,338.894L463.578,339.752L466.906,335.932L476.539,330.591z"
				},
				{
					"id":"SD-KA",
					"title":"Kassalā",
					"d":"M568.396,258.874L582.709,263.912L585.792,264.25L618.955,262.445L618.955,262.445L618.813,262.697L619.275,263.229L619.441,264.93L618.135,266.225L618.057,266.899L618.958,268.451L618.67,269.258L619.271,271.256L618.81,272.788L619.959,274.224L619.156,275.055L618.303,275.449L618.022,276.197L618.435,277.012L616.924,278.874L614.589,279.429L614.397,280.183L614.899,281.082L614.136,284.846L614.634,286.92L616.24,289.126L617.355,289.773L616.646,292.434L616.021,292.938L616.585,294.658L616.563,295.551L617.2,295.823L615.939,296.792L614.343,298.836L611.199,309.079L611.237,309.641L610.113,312.115L609.261,315.073L606.474,319.991L603.988,328.037L603.641,330.306L603.012,331.416L602.954,332.613L600.3,339.918L599.364,340.911L598.217,341.008L597.416,341.432L595.825,343.4L595.907,343.839L595.907,343.839L586.45,346.943L583.256,348.731L582.319,348.711L581.381,350.693L579.756,350.807L577.052,348.126L576.45,346.493L574.817,344.099L573.92,343.805L572.817,342.082L571.634,341.536L570.287,338.257L568.41,336.491L567.963,335.446L567.429,336.029L567.387,336.752L568.355,338.048L569.448,340.548L569.291,341.488L568.186,343.905L565.977,344.935L565.815,346.961L563.366,352.691L542.951,353.985L539.844,349.83L537.028,342.135L530.871,338.654L529.454,338.475L524.151,335.132L524.598,334.592L525.045,330.908L524.986,329.046L518.946,325.9L518.248,326.061L515.956,325.76L511.197,324.838L509.217,322.554L507.119,322.053L504.313,319.906L503.792,319.216L503.792,319.216L511.705,320.764L511.026,318.171L504.714,306.861L504.714,306.861L510.412,294.994L511.586,295.028L513.668,292.622L516.835,291.061L549.228,292.733L551.384,291.861L553.568,292.167L564.624,284.246z"
				},
				{
					"id":"SD-KH",
					"title":"Khartoum",
					"d":"M407.67,281.21L421.934,291.953L443.594,294.801L447.826,298.368L458.903,300.304L473.719,304.526L476.682,307.018L481.023,308.863L487.091,310.396L497.208,308.733L504.714,306.861L504.714,306.861L511.026,318.171L511.705,320.764L503.792,319.216L503.792,319.216L496.099,317.712L493.235,319.39L491.619,319.34L485.277,321.035L484.958,321.945L484.199,322.143L483.416,321.45L480.86,323.803L480.078,327.191L478.435,329.5L478.139,331.24L478.139,331.24L476.539,330.591L466.906,335.932L463.578,339.752L461.464,338.894L456.549,338.846L437.339,340.581L434.307,340.275L434.307,340.275L433.287,341.578L432.81,342.949L429.942,342.848L429.942,342.848L419.706,320.519L410.173,308.699L407.341,304.396L406.45,304.466L406.791,302.867L402.5,291.691L400.431,288.815L399.294,285.578L399.294,285.578z"
				},
				{
					"id":"SD-KN",
					"title":"North Kurdufān",
					"d":"M231.03,283.645L277.641,283.641L332.398,284.208L374.005,286.432L393.985,286.233L399.294,285.578L399.294,285.578L400.431,288.815L402.5,291.691L406.791,302.867L406.45,304.466L407.341,304.396L410.173,308.699L419.706,320.519L429.942,342.848L429.942,342.848L417.212,348.35L416.646,349.278L416.535,350.07L417.84,352.57L416.948,352.825L416.722,353.231L413.242,353.094L411.055,361.178L399.469,371.551L396.407,379.354L396.47,384.85L398.458,391.197L406.185,396.86L409.752,407.678L417.102,414.1L417.123,414.598L417.733,415.054L417.07,415.421L415.459,420.444L415.546,422.836L417.164,423.422L417.378,424.263L414.77,427.547L411.637,428.518L408.098,431.709L403.964,434.022L401.359,442.117L401.574,443.281L400.256,446.113L402.073,452.479L402.073,452.479L391.161,448.429L390.403,448.967L389.356,448.666L389,449.832L388.484,449.186L388.558,448.65L386.847,448.792L384.592,450.158L384.578,451.304L383.965,450.353L383.053,450.452L382.979,450.872L382.561,450.816L382.502,450.436L381.589,450.459L381.591,450.936L381.268,450.938L381.152,450.442L376.333,450.258L375.925,450.696L375.759,451.766L375.783,452.872L376.285,454.434L376.471,457.676L376.306,458.802L375.398,460.026L375,460.161L372.202,459.354L370.065,461.977L368.616,460.859L366.178,463.959L366.484,464.453L356.412,465.187L353.81,461.578L352.074,456.38L349.785,454.808L349.268,454.028L351.877,450.944L349.277,451.968L341.053,453.667L338.853,454.535L336.465,456.321L335.118,456.728L335.257,450.088L335.139,449.172L334.319,448.699L334.326,446.007L331.76,445.106L330.104,443.831L323.644,443.901L323.644,443.901L314.873,429.466L313.366,417.233L307.605,415.714L302.716,413.332L303.551,412.546L301.439,411.632L297.497,407.064L286.67,400.63L286.742,398.062L277.184,398.561L275.754,396.819L273.702,396.401L257.554,389.761L254.835,388.979L242.916,387.2L228.702,387.574L228.702,387.574L219.257,358.824L216.345,356.77L214.848,348.875L210.437,309.217L208.034,283.711z"
				},
				{
					"id":"SD-KS",
					"title":"South Kurdufān",
					"d":"M323.644,443.901L330.104,443.831L331.76,445.106L334.326,446.007L334.319,448.699L335.139,449.172L335.257,450.088L335.118,456.728L336.465,456.321L338.853,454.535L341.053,453.667L349.277,451.968L351.877,450.944L349.268,454.028L349.785,454.808L352.074,456.38L353.81,461.578L356.412,465.187L366.484,464.453L366.178,463.959L368.616,460.859L370.065,461.977L372.202,459.354L375,460.161L375.398,460.026L376.306,458.802L376.471,457.676L376.285,454.434L375.783,452.872L375.759,451.766L375.925,450.696L376.333,450.258L381.152,450.442L381.268,450.938L381.591,450.936L381.589,450.459L382.502,450.436L382.561,450.816L382.979,450.872L383.053,450.452L383.965,450.353L384.578,451.304L384.592,450.158L386.847,448.792L388.558,448.65L388.484,449.186L389,449.832L389.356,448.666L390.403,448.967L391.161,448.429L402.073,452.479L402.073,452.479L407.453,468.451L411.064,468.396L418.913,475.729L421.793,479.029L421.793,479.029L430.719,487.806L430.852,508.359L431.623,511.386L433.97,515.336L421.244,527.583L414.547,531.767L408.346,542.697L406.622,545.068L396.228,556.771L388.097,567.064L384.832,568.286L369.961,568.276L366.98,569.607L357.64,560.857L350.839,556.949L332.924,545.829L330.685,545.879L329.537,545.601L329.537,545.601L325.84,538.136L322.298,533.443L306.116,517.946L304.493,514.252L304.996,511.824L305.791,510.605L310.609,506.72L310.741,504.541L310.227,503.636L309.675,498.165L304.983,488.139L301.912,488.203L300.193,486.454L300.081,484.292L300.408,483.094L301.672,481.925L302.028,477.518L304.57,475.413L307.962,470.383L310.542,467.999L311.66,466.357L312.643,463.805L312.448,461.634L313.186,459.957L314.588,458.105L317.89,455.66z"
				},
				{
					"id":"SD-NB",
					"title":"Blue Nile",
					"d":"M463.217,486.696L488.79,470.084L501.267,467.187L510.653,461.396L510.5,459.635L509.012,458.577L514.525,452.785L516.355,453.768L517.057,453.384L523.585,454.955L524.522,456.171L526.865,457.171L533.474,475.624L532.854,477.235L539.093,486.483L539.093,486.483L539.377,487.874L540.23,489.793L540.292,494.929L538.095,500.557L535.594,504.698L535,505.087L534.543,506.113L534.077,506.434L534.238,506.746L535.532,506.738L536.967,508.281L537.119,509.024L535.337,518.262L536.388,520.679L531.688,524.399L531.675,525.758L531.294,526.546L528.344,528.466L528.03,528.471L528.553,526.583L527.534,526.598L521.184,520.732L520.711,520.583L520.092,521.141L518.92,521.314L517.998,522.581L515.275,523.875L511.918,529.798L510.383,531.777L508.442,533.59L507.705,535.809L507.716,536.513L508.814,536.809L509.617,538.127L508.26,540.987L509.493,545.636L510.639,548.626L510.272,549.427L510.428,550.78L509.896,551.882L509.913,553.054L508.444,554.169L506.892,554.816L505.812,555.77L505.209,559.339L505.147,561.738L502.261,569.325L501.683,572.531L500.409,576.215L500.549,578.8L491.88,578.921L491.854,576.802L491.396,574.669L491.52,572.51L492.903,568.421L494.367,566.319L495.806,560.632L495.583,559.357L495.706,557.064L494.802,553.975L494.993,552.619L494.331,550.88L491.409,550.858L487.521,544.024L482.598,540.566L475.025,531.55L465.564,528.444L467.981,524.104L461.136,492.369z"
				},
				{
					"id":"SD-NO",
					"title":"Northern",
					"d":"M390.649,49.833L432.257,50.136L432.257,50.136L427.533,138.459L427.641,152.202L425.177,186.991L440.509,202.649L437.739,218.35L442.604,233.063L434.371,244.394L408.832,281.055L407.67,281.21L407.67,281.21L399.294,285.578L399.294,285.578L393.985,286.233L374.005,286.432L332.398,284.208L277.641,283.641L231.03,283.645L231.03,283.645L231.03,137.246L129.004,137.091L129.004,137.091L129.004,50.358L134.687,50.129L189.241,50.003L319.442,50.077L333.056,50.358L333.056,50.095L386.866,50.043L388.432,45.29L390.613,42.378L393.231,40.465L394.797,42.408L391.64,46.769z"
				},
				{
					"id":"SD-NR",
					"title":"River Nile",
					"d":"M478.339,62.269L478.998,62.272L478.998,62.272L477.777,63.446L466.418,71.956L468.873,74.781L469.281,75.827L469.813,81.273L469.444,83.102L467.363,85.887L467.567,90.976L466.384,95.409L467.065,97.286L470.343,99.405L473.543,103.622L477.525,104.917L478.668,107.824L481.647,112.766L483.075,116.231L482.817,122.083L479.977,134.372L480.012,135.322L481.921,138.459L483.73,151.114L482.734,162.717L482.94,166.238L487.664,174.149L500.727,208.538L514.186,213.055L520.877,216.657L530.695,226.482L543.473,247.092L545.856,249.306L552.434,252.425L568.396,258.874L568.396,258.874L564.624,284.246L553.568,292.167L551.384,291.861L549.228,292.733L516.835,291.061L513.668,292.622L511.586,295.028L510.412,294.994L504.714,306.861L504.714,306.861L497.208,308.733L487.091,310.396L481.023,308.863L476.682,307.018L473.719,304.526L458.903,300.304L447.826,298.368L443.594,294.801L421.934,291.953L407.67,281.21L407.67,281.21L408.832,281.055L434.371,244.394L442.604,233.063L437.739,218.35L440.509,202.649L425.177,186.991L427.641,152.202L427.533,138.459L432.257,50.136L432.257,50.136L462.283,50.052z"
				},
				{
					"id":"SD-NW",
					"title":"White Nile",
					"d":"M434.307,340.275L437.646,342.135L438.721,341.725L439.064,342.051L440.758,342.468L440.932,342.969L442.453,343L442.988,343.673L445.046,344.705L445.396,346.401L446.448,347.688L446.698,348.439L445.895,351.375L442.041,348.501L441.817,349.447L440.173,351.364L443.32,353.836L442.375,354.823L444.319,356.048L444.965,355.736L447.749,357.63L448.734,357.028L449.383,357.392L449.871,356.967L450.715,357.616L450.832,358.271L451.559,359.153L451.206,361.081L450.673,360.93L450.403,360.18L449.352,358.952L448.27,359.266L448.787,360.168L447.424,361.254L445.905,361.781L446.257,363.744L448.724,366.87L448.177,367.758L447.396,367.569L446.827,367.88L446.33,367.324L443.65,367.472L442.476,368.228L439.396,368.377L438.661,369.689L434.512,368.728L432.773,370.872L433.117,371.255L432.816,372.064L434.399,373.115L435.44,372.129L436.185,372.702L435.126,373.861L436.843,375.123L438.564,373.422L440.317,374.376L439.031,375.632L438.509,377.846L438.797,378.479L438.457,378.884L436.896,378.43L437.283,379.889L438.49,380.277L439.273,382.743L438.762,382.957L438.357,381.921L435.734,381.991L434.033,384.19L434.836,385.069L435.65,384.336L438.029,385.035L437.603,387.285L438.271,387.935L437.321,388.131L437.23,388.899L438.558,392.272L438.019,394.789L439.277,395.724L440.017,395.394L440.766,396.772L443.008,396.607L442.808,398.565L444.612,402.354L444.732,403.601L443.827,405.215L444.835,409.216L454.491,408.959L454.491,408.959L454.865,411.602L454.433,412.58L455.409,414.165L454.817,417.596L453.542,421.373L453.172,423.518L460.253,433.506L463.903,437.598L458.836,447.362L463.159,457.13L465.904,466.764L465.904,466.764L444.224,466.026L444.469,466.731L444.387,470.63L445.271,473.692L445.122,475.315L444.102,477.471L444.224,479.004L421.793,479.029L421.793,479.029L418.913,475.729L411.064,468.396L407.453,468.451L402.073,452.479L402.073,452.479L400.256,446.113L401.574,443.281L401.359,442.117L403.964,434.022L408.098,431.709L411.637,428.518L414.77,427.547L417.378,424.263L417.164,423.422L415.546,422.836L415.459,420.444L417.07,415.421L417.733,415.054L417.123,414.598L417.102,414.1L409.752,407.678L406.185,396.86L398.458,391.197L396.47,384.85L396.407,379.354L399.469,371.551L411.055,361.178L413.242,353.094L416.722,353.231L416.948,352.825L417.84,352.57L416.535,350.07L416.646,349.278L417.212,348.35L429.942,342.848L429.942,342.848L432.81,342.949L433.287,341.578z"
				},
				{
					"id":"SD-RS",
					"title":"Red Sea",
					"d":"M678.262,214.446l0.352,0.652l-0.227,0.463l-0.432,-0.237l-0.136,0.296l0.59,0.237l0.805,1.162l-0.136,0.486l-0.216,-0.119l0.125,-0.415l-0.696,-0.844l-0.676,-0.14l-0.328,0.711l-0.432,-0.119l0.488,-0.688l-0.612,-0.664l0.124,-0.261l0.635,0.225L678.262,214.446zM672.129,213.272l1.451,0.32l0.113,0.237l-0.952,0.308l-0.782,-0.557L672.129,213.272zM673.523,212.264l1.19,0.724l0.203,0.439l-0.589,-0.024l-0.624,-0.451l-0.385,-0.498L673.523,212.264zM670.723,210.543l1.758,1.222l-0.964,0.119L670.723,210.543zM659.557,189.103l1.032,0.393l0.17,0.821l-1.281,-0.155l-0.317,-0.548L659.557,189.103zM666.234,187.114l0.51,0.202l-0.193,0.762l-0.203,-0.464l-0.851,0.06L666.234,187.114zM629.788,100.357l0.657,0.386l0.012,0.338l-0.488,2.845l-0.748,0.916l-0.306,-1.085l0.079,-2.122l0.147,-0.663L629.788,100.357zM604.168,38.088l0.93,0.804l-1.021,-0.098l0.079,0.451l-0.306,-0.11l-0.204,-0.512L604.168,38.088zM568.118,10.472l0.193,0.869l-0.476,0.423l0.056,-0.925l-0.476,-0.22l0.079,-0.416L568.118,10.472zM567.246,9.848l0.011,0.783l-0.896,-0.293l0.068,-0.306L567.246,9.848zM670.405,211.493l-0.192,0.344l0.736,0.558l-0.929,1.459l0.261,0.368l1.292,0.261l0.283,0.628l1.689,0.629l1.156,-0.273l-0.022,-0.391l-0.229,0.083l-0.497,-0.499l0.396,-0.32l1.009,0.261l0.794,1.115l-0.034,0.392l-0.216,0.285l-0.215,0.462l0.532,1.174l1.281,0.628l0.941,-0.877l0.011,0.367l0.806,0.581l-0.397,0.213l-0.726,-0.403l0.046,0.996l0.702,-0.095l0.646,0.604l-0.147,0.486l0.374,0.237l0.487,-0.178l0.567,-1.339l-0.646,-0.581l0.091,-0.545l1.542,1.422l0.782,1.754l-0.284,0.415l0.726,0.059l0.295,0.521l-5.315,5.098l-2.548,6.063l-0.097,1.03l-1.604,3.31l-2.01,0.629l-0.76,0.593l-0.195,1.393l-0.633,1.45l-0.681,0.181l-1.268,-0.374l-0.708,0.767l-0.755,-1.565l-0.421,0.38l-1.466,-0.007l-0.875,0.606l-0.308,1.551l0.215,1.783l-1.466,-0.065l-0.125,-2.988l-0.441,-0.528l-1.274,0.664l-0.887,-0.341l-1.278,1.749l-0.155,0.443l0.27,0.717l-2.351,1.344l-1.938,0.192l-0.542,-1.423l-0.814,-0.596l-2.026,0.166l-0.511,0.667l0.293,1.673l-0.372,0.341l-0.301,2.087l-6.253,0.418l-3.96,1.584l-0.377,1.259l-0.556,0.015l0.22,0.941l0.95,0.59l-0.152,0.511l-0.896,0.414l-0.134,1.243l0.694,0.85l-1.342,0.893l-0.382,1.444l-1.22,1.796l-0.921,0.132l-0.81,2.214l-3.412,-2.004l-2.403,0.796l-1.309,-0.13l-0.927,0.649l-2.798,0.263l-0.721,-1.052l-2.208,-0.24l-0.706,-0.516l-0.755,0.158l-0.642,0.93l0,0l-33.163,1.806l-3.083,-0.339l-14.313,-5.038l0,0l-15.962,-6.449l-6.577,-3.119l-2.384,-2.214l-12.777,-20.609l-9.818,-9.825l-6.691,-3.603l-13.459,-4.517l-13.063,-34.389l-4.724,-7.912l-0.206,-3.521l0.996,-11.603l-1.81,-12.655l-1.909,-3.137l-0.035,-0.951l2.841,-12.289l0.258,-5.852l-1.428,-3.465l-2.979,-4.942l-1.143,-2.906l-3.982,-1.296l-3.2,-4.216l-3.277,-2.12l-0.682,-1.876l1.184,-4.433l-0.204,-5.089l2.081,-2.786l0.368,-1.829l-0.531,-5.446l-0.408,-1.046l-2.455,-2.825l11.359,-8.51l1.221,-1.174l0,0l17.513,-1.994l6.345,-19.025l21.682,-3.981l10.586,-24.595l10.645,3.094l16.739,-15.758l0.204,0.932l0.386,0.343l0.012,1.483l0.34,0.232l0.182,-0.196l0.283,0.612l0.158,3.001l0.692,1.31l-0.624,-0.196l-0.057,0.857l0.51,0.465l0.046,-0.453l0.386,-0.012l0.215,0.894l2.812,3.83l0.17,-0.147l-0.317,-0.966l0.907,-0.257l1.893,4.048l1.859,1.846l0.884,0.354l0.012,0.513l2.472,0.611l-0.284,0.159l-0.158,0.904l0.669,-0.159l0.408,-0.77l0.578,0.708l3.105,0.403l1.849,0.721l1.7,-0.146l0.453,0.416l1.111,-0.134l0.714,1.075l1.304,0.232l0.521,0.843l0.544,0.037l0.295,1.013l0.681,0.476l0.646,2.783l0.658,1.184l2.811,2.171l0.806,0.354l0.419,-0.183l0.511,0.463l-0.147,1.097l0.771,1.865l5.26,2.644l2.335,2.302l0.749,0.219l0.146,0.804l0.794,0.414l0.521,0.767l0.624,-0.012l1.043,1.351l1.915,0.256l0.137,-0.377l0.929,0.706l0.171,1.144l1.201,0.767l0.59,0.949l2.063,0.863l-0.023,1.836l-0.714,1.653l-0.556,0.462l0.907,1.385l0.022,0.705l-0.521,0.146l-0.125,0.838l0.408,0.255l-0.192,1.81l0.295,0.23l0.102,0.741l0.17,0.304l-0.306,1.651l0.839,3.191l-0.068,1.517l0.283,0.679l-0.067,0.885l-0.521,0.279l0.396,0.23l0.306,-0.375l0.295,0.437l-0.192,0.97l0.317,0.254l-0.034,0.534l0.681,0.497l0.227,1.127l0.714,0.788l0.091,0.909l0.363,0.497l-0.386,0.061l-0.374,0.303l-0.125,0.485l0.283,0.133l0.465,-0.629l0.341,-0.013l1.043,2.313l0.691,0.775l-1.338,0.799l-0.193,0.242l-0.045,0.279l0.657,-0.133l0.839,-0.896l1.791,2.603l-1.394,0.157l-0.386,-0.411l-0.453,1.041l0.635,-0.314l0.113,0.75l0.419,-0.702l1.225,-0.206l1.235,1.343l1.429,2.226l1.439,1.524l1.349,0.75l0.205,0.653l1.484,1.317l0.521,0.967l1.065,1.063l0.545,1.788l1.235,0.954l-0.986,1.98l-1.599,0.084l-0.113,0.978l-1.496,-3.405l-0.307,-0.181l0.012,-0.785l0.386,-0.206l0.748,1.522l1.678,1.002l-0.511,-1.111l-0.566,-0.314l-0.771,-1.353v-0.495l0.34,-0.109l-0.216,-0.689l-0.669,0.109l-0.192,-0.423l-0.329,-0.048l-0.045,0.52l-0.477,-0.157l0.147,-1.124l-0.589,0.06l-0.103,0.895l-0.669,-0.435l-0.192,-0.798l0.556,-1.257l-0.396,-0.762l-0.953,-0.387l-0.736,-0.024l-0.329,0.302l-0.748,1.208l-0.022,0.701l0.17,0.617l0.952,0.314l-0.136,0.725l0.362,0.29l-0.441,0.797l0.34,0.327l-0.012,1.22l-0.521,0.266l-0.487,-0.435l-0.352,0.278l0.057,1.485l0.612,0.302l0.046,0.857l0.805,0.688l1.349,3.536l-0.17,0.711l0.386,0.35l0.136,3.979l0.532,3.122l-0.227,1.614l1.146,1.626l0.058,1.586l0.645,0.798l0.715,2.215l-0.487,2.526l0.295,1.035l-1.564,-0.12l-0.397,0.433l0.76,2.453l-0.76,1.214l0.193,2.86l0.476,0.925l-0.091,2.438l0.408,1.909l0.17,4.333l-0.192,1.044l-0.59,1.008l0.171,-0.924l-0.806,1.176l0.442,0.839l0.261,1.691l0.771,1.354l0.17,1.139l0.17,0.601l1.032,1.305v0.863l0.691,0.299l-0.216,5.82l-0.34,0.683l0.227,0.395l-0.702,1.101l0.136,-1.089l-0.295,-0.072l-0.261,1.161l0.295,3.553l0.283,0.933l1.825,2.774l-0.102,1.124l1.258,4.397l-0.079,1.457l0.386,1.229l-0.159,1.6l0.511,2.291l-0.261,0.704l0.374,1.193l-0.046,1.049l0.454,0.549l0.362,-0.286l-0.068,0.799l1.065,2.873l0.386,0.942l0.079,1.132l0.556,0.262l-0.578,1.346l0.93,2.18l-0.204,1.477l0.544,0.619l0.137,0.679l2.21,2.56l0.397,1.106l0.68,0.357l1.179,1.32l1.032,0.167l0.283,0.321l3.48,-0.726l0.782,-0.559l0.237,0.702l0.715,0.488l1.712,0.036l0.487,0.749l-0.283,0.536l1.031,0.618l-0.091,0.726l0.612,0.286l0.635,0.903l3.582,1.118l2.041,0.987l0.963,0.832l2.177,3.102l4.387,2.958l-0.067,0.285l-1.304,0.546l-0.283,1.935l0.362,0.487l-0.17,0.546l0.578,0.605l-0.158,0.38l0.997,1.495l1.7,0.273l-0.147,0.7l1.19,0.462l1.032,0.166l1.031,-0.121l0.76,-0.484l0.102,-0.546l-0.51,-0.451l0.317,-0.617h0.601L670.405,211.493z"
				},
				{
					"id":"SD-SI",
					"title":"Sennar",
					"d":"M496.338,393.359L497.504,394.927L498.99,395.63L499.593,398.391L500.533,400.15L501.161,400.281L501.91,401.927L502.902,402.728L504.707,402.374L504.937,402.775L506.347,403.459L507.277,403.225L508.153,403.527L510.168,403.326L510.806,405.72L507.96,406.96L511.072,413.861L519.349,423.299L520.09,423.275L520.663,423.866L521.785,423.957L521.578,424.513L522.671,426.42L525.445,426.082L525.789,426.386L526.358,426.153L527.424,426.417L527.959,427.084L528.492,427.157L528.799,427.73L528.765,428.591L529.609,429.479L529.363,430.48L532.032,432.056L532.415,432.589L532.304,433.163L534.364,434.683L535.448,434.849L535.757,435.842L536.767,436.295L537.602,435.871L540.312,438.094L541.526,437.782L542.325,437.893L543.872,439.356L544.906,440.88L546.409,441.159L546.755,441.808L547.782,442.051L549.384,443.056L550.455,444.349L555.902,445.381L556.885,445.14L557.798,445.345L560.076,444.628L561.684,445.954L563.804,446.535L565.57,447.475L565.57,447.475L565.072,448.184L565.335,448.912L565.02,449.786L564.301,450.168L563.533,449.991L554.647,465.305L555.113,465.962L554.969,466.928L554.396,467.422L553.46,467.405L550.652,472.341L551.115,473.151L550.975,474.139L550.301,474.566L549.449,474.465L548.346,477.594L547.602,477.834L541.085,482.797L539.011,486.079L539.093,486.483L539.093,486.483L532.854,477.235L533.474,475.624L526.865,457.171L524.522,456.171L523.585,454.955L517.057,453.384L516.355,453.768L514.525,452.785L509.012,458.577L510.5,459.635L510.653,461.396L501.267,467.187L488.79,470.084L463.217,486.696L463.217,486.696L466.104,468.991L467.977,466.696L465.904,466.764L465.904,466.764L463.159,457.13L458.836,447.362L463.903,437.598L460.253,433.506L453.172,423.518L453.542,421.373L454.817,417.596L455.409,414.165L454.433,412.58L454.865,411.602L454.491,408.959L454.491,408.959L453.884,405.07L454.804,402.689L456.451,401.301L457.854,400.604L459.735,400.153L458.07,397.821L457.687,393.025L458.194,391.833L458.64,389.412L460.635,389.325L460.526,390.516L461.04,390.571L462.938,389.909L463.793,389.828L464.594,390.286L465.162,389.822L465.998,389.837L466.99,390.523L469.292,391.411L469.888,396.287L474.204,396.555L474.074,397.111L472.329,398.002L472.618,398.711L473.418,399.052L474.575,398.644L476.316,396.909L480.636,396.686L480.668,395.211L479.28,393.749L479.933,393.331L480.994,393.331L481.565,392.746L480.464,390.447L480.603,390.095L482.096,389.82L482.463,389.318L482.504,387.711L484.992,388.152L485.408,389.802z"
				}
			]
		}
	}
};