/*global $*/
var currentDate = new Date();
var currentYear = currentDate.getFullYear();
var startYear = currentYear;
/**
 * Année des données ONU
 * Notamment pour les projections
 * */
var dataYear;
var popbirdyear = 0;
var popcurrentyear = 0;
var dataZone = {};
var dataZoneGen = {};

var dataZoneSim = {};

var dataSurvie = {};
var dataTrads = {};
var lg = getParam("lang") ? getParam("lang") : "fr";
var activeAjaxCount = 0;
//var q = new binder(function() {q.getZones(parseDataForZones);});

var tabActive = '';
var simulateur_categorie;

var minYearLibreCourbe = Number(currentYear);
var maxYearLibreCourbe = Number(minYearLibreCourbe) + 100;


var initCountryColors = ['fb0000', '0191fa', 'faa901', '1ec400', 'aa00c4', '173971', '3c6d1b', '6c1c1c', '551f69'];
var countryColors = clone(initCountryColors);
var currentCountriesColors = {};
var selectedCountries = [];
var currentChartData = [];
var currentChartMax = 0;
var currentChartMin = 0;
var countriesInOrder = [];
var allowEmptyCountries = false;

/**
 * Taille minimale/maximale des bulles en pixels
 * */
var minBulletSize = 3;
var maxBulletSize = 150;
var maxLegendeBulletSize = 75;
var minLegendeBulletSize = 3;
var realMinBulletSizeValue = Infinity;
var medBulletSize = Math.round((maxLegendeBulletSize - minBulletSize) / 2);
var minBulletSizeValue = 0,
    maxBulletSizeValue = 0;


window._paysValue = {};


var q;

$(document).ready(function() {



    /*********************************************************************/
    //Déclaration du binder.
    /*********************************************************************/

    q = new binder(function(b) {

        parseLocationHash();

        $.when(q.getTrads(function(res) {
                parseTrads(res)
            }))
            .then(function() {
                if (lg == 'fr') {
                    return q.getPaysFr(parseDataForPays)
                }
                else {
                    return q.getPaysEn(parseDataForPays)
                }
            })
            .then(function() {
                return q.getIndicateurs(parseDataForIndicateurs)
            }).then(function() {
                return q.getDistances(parseDataDistances)
            }).then(function() {
                return q.getContiguite(parseDataContiguite)
            })
            .then(initApp);

    });


});



/**
 * On récupère les paramètres dans le hash pour les réappliquer
 * par la suite
 * En attendant on les stock dans window.hashParameters
 * */
function parseLocationHash() {
    var hash = decodeURIComponent(window.location.hash);
    try {
        hash = JSON.parse(hash.substring(1, hash.length));
        window.hashParameters = hash;
    }
    catch (e) {
        window.hashParameters = {};
    }
    if (!window.hashParameters['ecran']) {
        window.showIntro = true;
    }
    else {
        window.showIntro = false;
    }
}

function parseTrads(data) {
    dataTrads["fr"] = {};
    dataTrads["en"] = {};
    dataTrads["es"] = {};
    for (var p in data) {
        dataTrads["fr"][data[p].trad_id] = data[p].trad_fr;
        dataTrads["en"][data[p].trad_id] = data[p].trad_en;
        dataTrads["es"][data[p].trad_id] = data[p].trad_es;
    }

    dataYear = dataTrads['fr']['dataYear'];
    $("#script_template_container").loadTemplate("#template", dataTrads[lg]);

}

function initApp() {

    console.log('(initapp)');

    initFilters();
    initSelects();
    initTypePays();
    genSliders(); //Les sliders.
    genTabs(); //Les onglets.



    $(document).on('change', '#select_liste_indic', updatedIndicateur);
    $(document).on('sumo:selected', '#select_liste_pays', handleSelectedPays);
    $(document).on('sumo:unselected', '#select_liste_pays', handleUnSelectedPays);
    $(document).on('change', 'input[name=type_pays]', handleChangeTypePays);
    $('#chart').on('plotly_afterplot plotly_autosize', handleChartUnit);

    handleTabChange(getCurrentEcran());
    createMap(true);


    updatedIndicateur();

    //activateTab(getCurrentEcran());

}


function initTypePays() {
    var type = window.hashParameters.type_pays ? window.hashParameters.type_pays : "tous";
    $('input[name=type_pays][value=' + type + ']').attr('checked', true);
}

function handleChangeTypePays(e) {
    resetMap();
    updateMap();
    updateChart();
}



function handleSelectedPays(event, params) {
    console.log('handleSelectedPays');
    if (window.ignoreSumoCountryEvent) {
        console.log('handleSelectedPays ignored');
        window.ignoreSumoCountryEvent = false;
        return;
    }
    var pays = window.currentMap.getObjectById((params.sumoValue));
    if (getCurrentEcran() == 'monde') {
        selectSingleCountry(pays);
    }
    else if (getCurrentEcran() == 'voisins') {
        selectSingleCountryVoisins(pays);
    } else if(getCurrentEcran() == 'paysalautre') {
        selectSingleCountryAlautre(pays);
    }
    updateLocationHash();
}


function handleUnSelectedPays(event, params) {
    console.log('handleUnSelectedPays');
    if (getCurrentEcran() == 'voisins') {
        console.log('handleUnSelectedPays ignored1');
        return;
    }
    if (window.ignoreSumoCountryEvent) {
        console.log('handleUnSelectedPays ignored');
        //window.ignoreSumoCountryEvent = false;
        return;
    }else if(getCurrentEcran() == 'paysalautre') {
        //selectSingleCountryAlautre(pays);
    }
    var pays = window.currentMap.getObjectById((params.sumoValue));
    unSelectSingleCountry(pays);
    updateLocationHash();
    if(getCurrentEcran() == 'paysalautre') {
        countriesInOrder = [];
        allowEmptyCountries = true;
        updateMap();
        
    }
}

/**
 * On vient de changer d'indicateur
 * On doit rechercher des données
 * */
function updatedIndicateur() {
    showOrHideChoixZone();
    loadDataForChart();
    loadDataForMap();
}


function showOrHideChoixZone() {
    if (getCurrentEcran() != 'monde') {
        $('#form_choix_zone_type').addClass('cacher');
        return;
    }
    /**
     * Les proportions sont définies
     * */
    if (window._indicateurs[getCurrentIndic()].indicateur_type == 1) {
        $('#type_pays_tous').attr('checked', true);
        $('#form_choix_zone_type').addClass('cacher');
    }
    else {
        $('#form_choix_zone_type').removeClass('cacher');
    }
}

function loadDataForChart() {
    updateLocationHash();
    var indic = getCurrentIndic();
    // Valeur pour tous les pays pour tous les 5 ans (graphique)
    q.getIndicateurEveryFiveYears(window._indicateurs[indic].indicateur_field, Number(dataYear), Number(dataYear) + 1, function(result) {
        parseDataChart(indic, result);
    });
}

function loadDataForMap() {

    var indic = getCurrentIndic();
    var annee = getCurrentAnnee();
    // Valeurs pour tous les pays pour l'année en cours (carte)
    q.getIndicateurByYear(window._indicateurs[indic].indicateur_field, annee, function(result) {
        updateMap(indic, annee, result);
        if (getCurrentEcran() == 'paysalautre') {
            updateChart(indic);
        }
    });
}





//Les sliders.
function genSliders() {
    var defaultYear = window.hashParameters['cartes_annee'] ? window.hashParameters['cartes_annee'] : currentYear;
    $('#year').html(defaultYear);
    genCustomSlider("#cartes_annee", defaultYear, t('_startYear'), t('_endYear'), "", "", true, 1, "", false, false, 1);
    $('#cartes_annee').on('slidechange', handleYearChange);


    var prop = window.hashParameters.prop ? window.hashParameters.prop : 20;
    genCustomSlider("#choix_proportion", prop, 0, 100, "", "", true, 1, "", true, false, 1);
    $('#choix_proportion').on('slidechange', handleProportionChange);
    $('#choix_proportion').on('slide', handleProportionChange);

    genCustomSlider("#cartes_distance", 1000, 0, 4000, "", "", true, 1, "", false, false, 1);
    $('#cartes_distance').on('slidechange', handleDistanceChange);
    //$('#choix_proportion').on('slide', handleDistanceChange);

}

function handleDistanceChange(e) {
    updateMap();
    updateChart();
    updateLocationHash();
}

function handleYearChange(e) {
    $('#year').html(getCurrentAnnee());
    loadDataForMap();
    if (getCurrentEcran() != 'paysalautre') {
        updateChart();
    }

    updateLocationHash();
}





/*********************************************************************/
//Gestion des sliders.
/*********************************************************************/


function displaySliders(elements, display) {
    if (display) {
        $(elements).slider("disable");
        $(elements).parent('.slider_wrapper').children('span.sbutton').css({
            'opacity': 0.35
        }).addClass('disabled');
    }
    else {
        $(elements).slider("enable");
        $(elements).parent('.slider_wrapper').children('span.sbutton').css({
            'opacity': 1
        }).removeClass('disabled');
    }
}


/*********************************************************************/
//Gestion des onglets.
/*********************************************************************/
function genTabs() {
    //Création des onglets.
    var ecran = window.hashParameters['ecran'] ? window.hashParameters['ecran'] : 'monde';


    $("#contenu").tabs({
        create: function(event, ui) {
            if (window.showIntro) {
                $('#ecran').val(ecran);
                window.showIntro = false;
                $('#simulateur_module').addClass('off');

            }
            else {
                $('#simulateur_module').removeClass('off');
                $('#simulateur_introduction').hide();
            }
            var tabSelected = $("#tabs_menu ul li.ui-state-active");
            TweenMax.to("#tabs_cursor", 0, {
                "left": getCursorPos()
            });
            TweenMax.to(tabSelected, 1, {
                backgroundColor: "#1FBDC3"
            });

            //En fonction de l'onglet cliqué.
            simulateur_categorie = $(tabSelected).children('a').data('categorie');
            $('#ecran').val(simulateur_categorie);
            setTimeout(function() {
                $('#tabs_menu_content [data-categorie=' + ecran + ']').click();
                $('#ecran').val(ecran);
            }, 10);

        },
        activate: function(event, ui) {
            $('#simulateur_module').removeClass('off');
            $('#simulateur_introduction').hide();
            var tabSelected = $(ui.newTab.context).parent('li');
            TweenMax.to("#tabs_cursor", 0.5, {
                "left": getCursorPos()
            });
            TweenMax.to("#tabs_menu li", 0.6, {
                backgroundColor: "#222E3B"
            });
            TweenMax.to(tabSelected, 1, {
                backgroundColor: "#1FBDC3"
            });
            //En fonction de l'onglet cliqué.
            simulateur_categorie = $(ui.newTab.context).data('categorie');
            $('#ecran').val(simulateur_categorie);
            activateTab(simulateur_categorie);
        }

    });

}

/**
 * Modification des DIV et textes à afficher selon l'écran     
 **/
function handleTabChange(ecran) {
    /* $('#simulateur_introduction').hide();
     $('#simulateur_module').show();*/
    if (ecran == 'voisins') {
        $('#form_choix_zone_type').addClass('cacher');
        $('#form_choix_distance').removeClass('cacher');
        $('#help_map').html(t('cartes-help_voisins'));
        $('#help_chart').html(t('cartes-help_chart_voisins'));
    }
    else if (ecran == 'paysalautre') {
        $('#form_choix_distance').addClass('cacher');
        $('#form_choix_zone_type').addClass('cacher');
        $('#help_map').html(t('cartes-help_paysalautre'));
        $('#help_chart').html(t('cartes-help_chart_paysalautre'));
    }
    else if (ecran == 'monde') {
        $('#form_choix_distance').addClass('cacher');
        $('#form_choix_zone_type').addClass('cacher');
        $('#help_map').html("");
        $('#help_chart').html(t('cartes-selectionnez_courbe'));
    }
}


/**
 * On vient de cliquer sur un tab
 * */
function activateTab(ecran) {
    handleTabChange(ecran);
    showOrHideChoixZone();
    resetMap();
    reselectSelectedCountries();
    updateMap();
    updateChart();
    updateLocationHash();
}

function getCursorPos() {
    var tabSelected = $("#tabs_menu ul li.ui-state-active");
    var tabPosX = $(tabSelected).position().left;
    var tabWidth = $(tabSelected).width();

    var newPos = tabPosX + (tabWidth / 2) - 5;
    return newPos;
}




function initFilters() {

    var filters = [];
    for (var p in countryColors) {
        filters.push('<filter id="inset_' + countryColors[p] + '" x="-50%" y="-50%" width="200%" height="200%">\
      <feFlood flood-color="#' + countryColors[p] + '" result="inside-color"/>\
      <feComposite in2="SourceAlpha" operator="in" result="inside-stroke"/>\
      <feMorphology in="SourceAlpha" operator="erode" radius="2"/>\
      <feComposite in="SourceGraphic" operator="in" result="fill-area"/>\
      <feMerge>\
        <feMergeNode in="inside-stroke"/>\
        <feMergeNode in="fill-area"/>\
      </feMerge>\
    </filter>');
    }
    $('#filters').html('<defs>' + filters.join('') + '</defs>');
}



/***
 * On transforme les SELECT basiques en select multiples
 * */
function initSelects() {
    $('#select_liste_indic').SumoSelect({
        search: true,
        searchText: t('indicateurs'),
        captionFormat: '{0} ' + t('selectionnes'),
        forceCustomRendering: true,
        nativeOnDevice: ['iPad']
    });
    $('#select_liste_pays').SumoSelect({
        search: true,
        searchText: t('pays'),
        captionFormat: '{0} ' + t('selectionnes'),
        forceCustomRendering: true,
        nativeOnDevice: ['iPad']
    });
}
