/**
 * Retourne l'objet Area Pays réel si jamais l'objet passé en est un alias
 * (ex. bulles)
 * */
function getRealObject(obj) {
    if (obj.linkToObject) {
        return window.currentMap.getObjectById(obj.linkToObject);
    }

    return obj;
}


/**
 * Affiche la bulle d'information avec le pays et sa valeur actuelle
 * @var e event Rollover
 * */
function showInfoBubble(e) {

    /**
     * Objet au rollover
     * */
    var obj = e.mapObject;

    // Si cet objet est un "rond" on récupère son pays lié
    var cc = obj.linkToObject ? obj.linkToObject : obj.id;

    // Et on récupère le détail du pays
    var pays = getPaysByIso(cc);

    if (!pays) {
        return;
    }

    console.log(cc);
    /***
     * On remet la couleur qu'il a déjà ....
     * Pas trouvé d'autres solutions ....
     * */
    var paysArea = window.currentMap.getObjectById(cc);
    paysArea.color = paysArea.colorReal;
    paysArea.validate();


    /**
     * On affiche le message au dessus avec le nom et la valeur
     * */
    $('#tooltip').html('<h3>' + pays['pays_nom_' + lg] + '</h3><p>' +
        formatNb(window._paysValue[cc]) +
        " (" +
        window._indicateurs[getCurrentIndic()]['indicateur_title_' + lg] +
        ")" +
        '</p>').addClass('active');

    return false;

}


/**
 * Affichage des valeurs sous forme de bulles
 * @var result Array Resultat fourni par sqlite
 * */
function buildBubbleImages(result) {


    /**
     * Valeurs absolues de l'indicateur actuel
     * */
    var min = Infinity;
    var max = -Infinity;
    realMinBulletSizeValue = Infinity;

    var color = "";


    var multiplyByMille = shouldIMultiplyByMille();

    /**
     * Calcul des min/max selon la valeur absolue de l'indicateur pour les
     * tailles de cercles
     * */
    for (var i = 0, l = result.length; i < l; i++) {
        if (multiplyByMille && !result[i].m) {
            result[i].V = result[i].V * 1000;
            result[i].m = true;
        }
        var value = Math.abs(result[i].V);
        if (value < min) {
            min = value;
        }
        if (value > max) {
            max = value;
        }
        if (result[i].V < realMinBulletSizeValue) {
            realMinBulletSizeValue = result[i].V;
        }
    }


    minBulletSizeValue = min;
    maxBulletSizeValue = max;


    // it's better to use circle square to show difference between values, not a radius
    var maxSquare = maxBulletSize * maxBulletSize * 2 * Math.PI;
    var minSquare = minBulletSize * minBulletSize * 2 * Math.PI;


    // Valeur stockée pour affichage ultérieur
    window._paysValue = {};

    // create circle for each country
    var images = [];

    for (var i = 0, l = result.length; i < l; i++) {


        var dataItem = result[i];
        var id = dataItem.P;
        var rowPays = getPaysById(id);
        /**
         * Parfois on a des résultats pour des "régions",
         * on ne les affiche pas !
         * */
        if (!rowPays) {
            continue;
        }

        // On garde la valeur exacte !
        window._paysValue[rowPays.pays_iso2] = dataItem.V;

        // On prend la valeur absolue pour la taille du cercle
        var value = Math.abs(dataItem.V);

        // La couleur est déterminée selon si la valeur est négative ou
        // positive
        color = dataItem.V >= 0 ? '#1FBDC3' : '#222E3B';

        // Calcul de la taille de la bulle en pixel
        var square = (value - minBulletSizeValue) / (maxBulletSizeValue - minBulletSizeValue) * (maxSquare - minSquare) + minSquare;
        if (square < minSquare) {
            square = minSquare;
        }
        var size = Math.sqrt(square / (Math.PI * 2));
        //size = value * (maxBulletSize / maxBulletSizeValue);

        // On créé le tout
        images.push({
            "type": "circle",
            "theme": "light",
            "alpha": .5,
            "outlineAlpha": "1",
            "outlineThickness": "1",
            "outlineColor": "#FFFFFF",
            "selectedColor": "#000000",
            "mouseEnabled": true,
            "selectable": false,
            "width": size,
            "height": size,
            "color": color,
            // Objet "Pays" lié pour gérer les hover/click/...
            "linkToObject": rowPays.pays_iso2,
            "longitude": rowPays.pays_lng,
            "latitude": rowPays.pays_lat,
            "value": value
        });
    }
    // Pourquoi il y avait ça ???? :
    // return [];
    return images;

}

/**
 * On construit les couleurs pour chaque pays
 * @var result array résultat de recherche SQL
 * */
function buildColors(result) {

    // Liste des zones
    var areas = [];
    // Indicateur courant
    var indic = getIndicateurById(getCurrentIndic());
    // Liste des couleurs de l'indicateur
    var indic_colors = indic.indicateur_values_colors;
    // Dernière couleur (la plus élevée) de l'indicateur
    var last_color = indic_colors[indic_colors.length - 1];
    // Liste des valeurs "bornes" de l'indicateur
    var indic_values = indic.indicateur_values;
    // Couleur du pays en cours
    var color = '';
    // Code pays en cours
    var cc = '';
    // Valeur en cours
    var v;

    window._paysValue = {};

    for (var p in result) {

        /**
         * Couleur par défaut (la plus élevée) si jamais la boucle
         * ne trouve rien
         * */
        color = last_color;

        /**
         * Recherche de la couleur correspondante à la liste
         * des valeurs pour cet indicateur
         * @var v = la valeur
         * */
        v = result[p].V;
        for (var k in indic_values) {
            if (v < indic_values[k]) {
                /**
                 * La valeur doit être inférieure à la valeur "borne"
                 * */
                color = indic_colors[k]
                break;
            }
        }

        /**
         * Pays en cours
         * */
        cc = getPaysById(result[p].P).pays_iso2;

        window._paysValue[cc] = result[p].V;

        areas.push({
            'id': cc,
            'color': '#' + color
        });

    }


    return areas;

}

function getCountryNeighbors(cc) {
    if (window._contiguite[cc]) {
        return window._contiguite[cc];
    }
    else {
        return [];
    }
}

function buildMapPaysALAutre(result) {
    // Liste des zones
    var areas = [];
    // Indicateur courant
    var indic = getIndicateurById(getCurrentIndic());
    // Code pays en cours
    var cc = '';
    // Valeur en cours
    var v;

    if (countriesInOrder.length == 0) {
        /***
         * On a encore aucun pays sélectionné
         * */
        if (allowEmptyCountries) {
            /**
             * On peut l'autoriser si on vient de déselectionner un pays notamment
             * */
            allowEmptyCountries = false;
        }
        else {
            /**
             * Sinon on essai de retrouver un pays de départ depuis le select
             * */
            var cp = getCurrentPays();
            if (cp.length > 0) {
                countriesInOrder.push(cp[0]);
            }
            else {
                /**
                 * Sinon la france ..
                 * */
                countriesInOrder.push('FR');
            }
        }
    }
    else if (countriesInOrder[0] == 'WW') {
        /**
         * Si le pays sélectionné est le monde , on prend la france à la place
         * */
        countriesInOrder = ['FR'];
    }

    /***
     * Liste des pays sélectionnés
     * */
    var cs = countriesInOrder;
    /**
     * Premier pays de la liste (couleur différente)
     * */
    var firstCountry = cs.length > 0 ? cs[0] : false;
    /**
     * Dernier pays de la liste
     * */
    var lastCountry = cs.length > 0 ? cs[cs.length - 1] : false;
    /**
     * Voisins cliquables
     * */
    var voisins = getCountryNeighbors(lastCountry);

    window.currentMap.dataProvider.lines = [];

    var star = 'M8 12.9l4.9 3.1-1.3-5.9 4.4-4-5.8-.5L8 0 5.8 5.6 0 6.1l4.4 4L3.1 16';

    if (countriesInOrder.length > 1) {

        var lines = [];
        for (var p = 1; p < countriesInOrder.length; p++) {
            var previous = countriesInOrder[p - 1];
            var cur = countriesInOrder[p];

            var line = new AmCharts.MapLine();
            line.id = "line" + previous + cur;
            line.latitudes = [window._paysIso[previous].pays_lat, window._paysIso[cur].pays_lat];
            line.longitudes = [window._paysIso[previous].pays_lng, window._paysIso[cur].pays_lng];
            line.color = '#222E3B';
            window.currentMap.dataProvider.lines.push(line);
        }
    }
    var arr = {};
    window._paysValue = {};
    var previous = false;
    var images = [];
    /**
     * On parcourt tous les pays
     * */
    for (var p in result) {

        /**
         * Code iso du pays
         * */
        cc = result[p].P;
        var iso = getPaysById(cc).pays_iso2;

        if (pays) {
            previous = pays;
        }
        /**
         * Objet DOM PATH  du pays
         * */
        var pays = window.currentMap.getObjectById(iso);

        /**
         * Certains paysn de la base ne sont pas sur la carte
         * */
        if (!pays || !pays.displayObject)
            continue;


        pays.selected = false;

        if (iso == firstCountry) {
            /**
             * Premier pays couleur à part
             * */
            pays.color = '#1FBDC3';

            pays.selected = true;
        }
        else if (cs.indexOf(iso) > -1) {
            /**
             * Un des pays sélectionné
             * */
            pays.color = '#52F0F6';

            pays.selected = true;
        }
        else if (voisins.indexOf(iso) > -1) {
            /**
             * Un des pays voisins cliquables
             * */
            pays.color = '#B8FFFF';
        }
        else {
            /**
             * Tous les autres
             * */
            pays.color = '#FFFFFF';
        }

        if (pays.selected) {

            var img = new AmCharts.MapImage();

            img.svgPath = star;
            img.width = 10;
            img.height = 10;
            img.color = '#222E3B';
            img.value = "CIRC" + iso;
            img.id = "CIRC" + iso;
            img.latitude = window._paysIso[iso].pays_lat;
            img.longitude = window._paysIso[iso].pays_lng;
            img.fixedSize = true;
            images.push(img);

        }

        pays.selectedColor = pays.color;
        pays.validate();

        /**
         * On stock la valeur pour l'histogramme
         */
        window._paysValue[iso] = result[p].V;
    }


    if (lastCountry) {
        pays = window.currentMap.getObjectById(lastCountry);
        pays.images = images;
        window.currentMap.selectObject(pays);
    }
    else {
        window.currentMap.selectObject();
    }

    /**
     * On dit à buildMap de pas tout mettre à jour, on a déjà tout fait.
     * */
    return false;
}

function buildColorsExtremes(result) {

    // Liste des zones
    var areas = [];
    // Indicateur courant
    var indic = getIndicateurById(getCurrentIndic());
    // Code pays en cours
    var cc = '';
    // Valeur en cours
    var v;

    window._paysValue = {};
    var arr = {};

    /**
     * Tri des résultats
     * */
    if ((getCurrentTypePays() == 'eleve')) {
        result.sort(function (a, b) {
            return b.V - a.V;
        });
    }
    else {
        result.sort(function (a, b) {
            return a.V - b.V;
        });
    }


    var percent = getCurrentProportion();
    var nbRes = result.length;

    var nbPaysATrouver = Math.ceil((nbRes / 100) * percent);
    var totPop = 0;
    var currentPop = 0;

    if (window.currentMap) {

        for (var p in result) {
            cc = result[p].P;
            var iso = getPaysById(cc).pays_iso2;

            var pays = window.currentMap.getObjectById(iso);

            if (!pays || !pays.displayObject)
                continue;
            totPop += result[p].T;
            // console.log(pays.displayObject);
            window._paysValue[iso] = result[p].V;
            if (p < nbPaysATrouver) {
                pays.color = '#1FBDC3';

                //pays.displayObject.node.setAttribute('fill', '#1FBDC3');
                currentPop += result[p].T;

            }
            else {
                pays.color = '#ffffff';
                //pays.displayObject.node.setAttribute('fill', '#ffffff');
            }
            pays.selectable = false;
            pays.validate();
        }

        updateChartPopulationProportion((currentPop / totPop) * 100);

        return false;
    }


    /**
     * Modification en différé de la carte
     * */


    for (var p in result) {
        cc = result[p].P;
        if (p <= nbPaysATrouver) {
            areas.push({
                'id': getPaysById(cc).pays_iso2,
                'color': '#1FBDC3'
            });
            currentPop += result[p].T;
        }
        totPop += result[p].T;
    }
    console.log(currentPop, '/', totPop);
    updateChartPopulationProportion((currentPop / totPop) * 100);
    return areas;
    //}

}


/**
 * Cache le tooltip d'info d'un pays
 * */
function hideInfoBubble(e) {
    $('#tooltip').removeClass('active');
}

/**
 * On met à jour la carte
 * */
function updateMap(indic, annee, result) {

    console.log('*********** UPDATE MAP');

    indic = indic ? indic : getCurrentIndic();
    annee = annee ? annee : getCurrentAnnee();
    result = result ? result : window.currentMapResults;
    window.currentMapResults = result;

    var mapType = window._indicateurs[indic].indicateur_type;
    var ecran = getCurrentEcran();
    var type = getCurrentTypePays();

    images = colorValues = [];

    if (!window.currentMap) {
        createMap(true);
    }


    if (ecran == 'monde') {
        if (type == 'tous') {
            if (mapType == 1) {
                /**
                 * Bubble maps
                 * */

                var images = buildBubbleImages(result);
            }
            else {
                /**
                 * Chronopleth
                 * */
                var colorValues = buildColors(result);
            }
        }
        else {
            /**
             * Celui là met à jour directement les couleurs
             *
             * */
            var colorValues = buildColorsExtremes(result);

        }
    }
    else if (ecran == 'voisins') {
        var colorValues = buildMapVoisins();

    }
    else if (ecran == 'paysalautre') {
        var colorValues = buildMapPaysALAutre(result);

    }

    var indic = getIndicateurById(getCurrentIndic());
    updateLegende(indic);


    if (colorValues === false) {
        return;
    }
    console.log('BUILDING MAP');
    console.log(colorValues);


    var x = window.currentMap.zoomX();
    var y = window.currentMap.zoomY();
    var z = window.currentMap.zoomLevel();
    window.currentMap.dataProvider.images = images;
    window.currentMap.dataProvider.areas = colorValues;

    window.currentMap.validateData();

    window.currentMap.zoomTo(z, x, y, true);
    reselectSelectedCountries();

}

function resetMap() {

    if (!window.currentMap) {
        return;
    }

    window.currentMap.dataProvider.lines = [];
    window.currentMap.dataProvider.lines = [];

    var obj;
    for (var p in currentCountriesColors) {
        obj = window.currentMap.getObjectById(p);
        obj.insetColor = '';
        obj.images = [];
        obj.isSelected = false;
        $(obj.displayObject.node).attr('filter', '');
    }
    countryColors = clone(initCountryColors);
    currentCountriesColors = {};
    /*
        var x = window.currentMap.zoomX();
        var y = window.currentMap.zoomY();
        var z = window.currentMap.zoomLevel();
        */
    // window.currentMap.dataProvider.areas = [];

    if (window.currentMap.dataProvider.images[0]) {
        $(window.currentMap.dataProvider.images[0].displayObject.node).parent().remove();
    }
    $('.amcharts-chart-div path').attr('cursor', '');
    window.currentMap.dataProvider.images = [];
    window.currentMap.selectObject();
    //createMap();
    //  window.currentMap.zoomTo(z, x, y, true);
}


function buildMapVoisins() {

    var distance = getCurrentDistance();

    for (var p in selectedCountries) {
        var currentCountry = p;
        break;
    }

    if (!currentCountry) {
        var currentCountry = 'FR';
    }

    var distancesPays = window._distancesPays[currentCountry];
    var voisins = [];
    for (var p in distancesPays) {
        if (distancesPays[p].M < distance) {
            voisins.push(distancesPays[p].Q);
        }
    }

    window.voisinsPays = [];

    for (var p in window.currentMap.dataProvider.areas) {

        var obj = window.currentMap.dataProvider.areas[p];
        obj.images = [];
        if (obj.id == currentCountry) {
            obj.color = '#1FBDC3';
            obj.validate();
            window.voisinsPays.push(obj.id);
        }
        else if (voisins.indexOf(obj.id) > -1) {
            obj.color = '#4FEDF3';
            obj.validate();
            window.voisinsPays.push(obj.id);
        }
        else if (obj.color != '#FFFFFF') {
            obj.color = '#ffffff';
            obj.validate();
        }


    }


    window.currentMap.selectedObject = window.currentMap.dataProvider;

    return false;

}

function defaultClickMethod(event) {
    var obj = getRealObject(event.mapObject);
    cancelClickState(obj);
}


function clickPays(event) {
    var methodClickPays = defaultClickMethod;
    var selectable = true;
    var ecran = getCurrentEcran();

    if (ecran == 'monde') {
        var curTypePays = getCurrentTypePays();
        if (curTypePays == 'tous') {
            methodClickPays = clickPaysMonde;
        }
        else {
            selectable = false;
        }
    }
    else if (ecran == 'voisins') {
        methodClickPays = clickPaysVoisins;
    }
    else if (ecran == 'paysalautre') {
        methodClickPays = clickPaysALAutre;
    }
    methodClickPays(event);

}

function createMap(reselect) {


    var methodClickPays = clickPays;


    var map = AmCharts.makeChart("maps", {
            "preventDragOut": true,
            "type": "map",
            "theme": "light",
            "panEventsEnabled": true, //"backgroundColor": "#666666",
            "showObjectsAfterZoom": true,
            "zoomDuration": 0,
            //"backgroundAlpha": 1,

            "dataProvider": {

                "map": "worldLow",
                "getAreasFromMap": true,
                "images": [],
                "areas": [],
                "lines": [
                    /*{
                                        "id": "linesContainer",
                                        "latitudes": [51.5002, 50.4422],
                                        "longitudes": [50.1262, 30.5367],
                                        "lines": [{
                                            "latitudes": [51.5002, 50.4422],
                                            "longitudes": [50.1262, 30.5367],
                                        }]
                                    }*/
                ]
            },
            "areasSettings": {
                "alpha": 1,
                "autoZoom": false,
                "color": "#FFFFFF",
                /*"color": '#' + indic.indicateur_values_colors[0],
                "colorSolid": '#' + indic.indicateur_values_colors[indic.indicateur_values_colors.length - 1],*/
                "selectedColor": "#FFFFFF",
                "outlineColor": "#2A757E",
                "outlineThickness": 1,
                "selectedOutlineColor": "#2A757E",
                "rollOverColor": "#FFFFFF",
                "rollOverOutlineColor": "#FFFFFF",
                "selectable": true,
                "balloonText": '',
                "showAsSelected": false,
                "bringForwardOnHover": false

            },
            "listeners": [{
                "event": "clickMapObject",
                "method": methodClickPays
                /*,
                                    "method": selectAndLink*/
            }, {
                "event": "rollOverMapObject",
                "method": showInfoBubble
            }, {
                "event": "rollOutMapObject",
                "method": hideInfoBubble
            }, {
                "event": "positionChanged",
                "method": mapDragCompleted
            }, {
                "event": "homeButtonClicked",
                "method": mapHomeButtonClicked
            }],
            "export": {
                "enabled": false
            },
            "mouseWheelZoomEnabled": true
        }
    );

    window.currentMap = map;
    if (reselect && getCurrentEcran() == 'monde') {
        for (var p in window.hashParameters['select_liste_pays']) {
            selectSingleCountry(window.currentMap.getObjectById(window.hashParameters['select_liste_pays'][p]));
        }
    }
}

function mapDragCompleted(e) {
    console.log(e);
}

function mapHomeButtonClicked() {
    unselectAllCountries();
    countriesInOrder = [];

    createMap(false);
    updateMap();
    setTimeout(function () {
        updateChart();
        updateLocationHash();
    }, 10);
}

function clickPaysMonde(event) {

    var map = event.chart;
    /**
     * Déselectionner le pays qu'on vient de cliquer ...
     * Obligé pour pouvoir en sélectionner plusieurs
     * */
    map.selectedObject = map.dataProvider;
    var obj = getRealObject(event.mapObject);
    cancelClickState(obj);


    if (!obj.isSelected) {
        /**
         * L'objet n'est pas actuellement sélectionné :
         * On le sélectionne
         * */
        selectSingleCountry(obj);
    }
    else {
        /**
         * Déjà sélectionné ...
         * on déselectionne  ....
         * */
        unSelectSingleCountry(obj);
    }

}

function clickPaysVoisins(event) {
    var map = event.chart;
    map.selectedObject = map.dataProvider;
    var obj = getRealObject(event.mapObject);
    cancelClickState(obj);
    selectSingleCountryVoisins(obj);
}

function clickPaysALAutre(event) {
    var map = event.chart;
    map.selectedObject = map.dataProvider;
    var obj = getRealObject(event.mapObject);
    var iso = obj.id;
    cancelClickState(obj);
    var cs = countriesInOrder;

    window.ignoreSumoCountryEvent = true;
    if (cs.indexOf(iso) >= 0) {
        /**
         * Pays existant on déselectionne
         * */
        countriesInOrder = [];
        unselectAllCountries();

        for (var p in cs) {
            p = cs[p];
            if (p == iso) {
                break;
            }
            /***
             * On n'ajoute que les pays précédents
             * */
            window.ignoreSumoCountryEvent = true;
            countriesInOrder.push(p);
            selectCountryInSelect(p);
        }
        if (countriesInOrder.length == 0) {
            allowEmptyCountries = true;
        }

    }
    else {
        /**
         * Nouveau Pays de départ
         * */
        if (cs.length == 0) {
            countriesInOrder.push(iso);
            selectCountryInSelect(iso);
        }
        else {
            /**
             * Nouveau pays dans la suite
             * */
            var lastCountry = cs[cs.length - 1];
            var voisins = getCountryNeighbors(cs[cs.length - 1]);

            if (cs.length == 9) {
                showMessage(t('pays_9max'));
            }
            else if (voisins.indexOf(iso) > -1) {
                countriesInOrder.push(iso);
                selectCountryInSelect(iso);
            }
            else {
                showMessage(t('pays_contigue'));
            }

        }
    }
    window.ignoreSumoCountryEvent = false;
    updateMap();
    setTimeout(updateChart, 10);
}


function cancelClickState(obj) {

    var r = obj.colorReal;
    obj.color = r;
    obj.validate();
}


/**
 * Met à jour la légende en fonction du type d'indicateur
 * @var indic object Indicateur
 * */
function updateLegende(indic) {

    indic = indic ? indic : window._indicateurs[getCurrentIndic()];

    /**
     * Indicateur courant
     * */
    window._currentIndic = indic;

    var resMap = '',
        resChart = '';

    var ecran = getCurrentEcran();

    if (ecran == 'monde') {
        if (getCurrentTypePays() == 'tous') {
            if (indic.indicateur_type == 1) {
                /***
                 * Type 1 = Cercles
                 * */
                resMap = updateLegendeCircles(indic);
            }
            else {
                /**
                 * Type 0 = Couleurs
                 * */
                resMap = updateLegendeColors(indic);
            }

            resChart = getLegendeCountriesColors();
        }
    }
    else if (ecran == 'voisins') {
        resChart = getLegendeChartVoisins();
        resMap = getLegendeMapVoisins();
    }

    var h = htop = "<h3>" + indic['indicateur_title_' + lg] +
        " <span> " + indic['indicateur_label_' + lg];

    if (indic['indicateur_type'] == 1) {
        h += " (" + t('unite_K') + ')';
    }
    if (indic['indicateur_unit_' + lg]) {
        h += " (" + indic['indicateur_unit_' + lg] + ")";
        htop += " (" + indic['indicateur_unit_' + lg] + ")";
    }
    h += "</span></h3>";
    htop += "</span></h3>";
    $('#chart_top').html(htop);
    h += resMap;
    $('#legende').html(h);
    $('#legende_chart').html(resChart);
}


function getLegendeChartVoisins() {
    if (!getCurrentPays()) return;
    var l = ['<ul class="legende legende_colors">'];

    l.push('<li><span class="legende_color" style="background-color:#d2f2f3"></span>');
    l.push(t('cartes_voisins_min'));
    l.push('<li><span class="legende_color" style="background-color:#222E3B"></span>');
    l.push(getPaysByIso(getCurrentPays()[0])['pays_nom_' + lg]);
    l.push('</li>');
    l.push('<li><span class="legende_color" style="background-color:#1FBDC3"></span>');
    l.push(t('cartes_voisins_max'));
    l.push('</li>');
    l.push('</li>');
    l.push('</ul>');
    return (l.join(''));
}

function getLegendeMapVoisins() {
    var l = ['<ul class="legende legende_colors">'];
    l.push('<li><span class="legende_color" style="background-color:#1FBDC3"></span>');
    l.push(t('cartes_voisins_pays'));
    l.push('</li>');

    l.push('<li><span class="legende_color" style="background-color:#4FEDF3"></span>');
    l.push(t('cartes_voisins_voisins'));
    l.push('</li>');

    l.push('</ul>');
    return (l.join(''));
}

function getLegendeCountriesColors() {
    var l = ['<ul class="legende legende_colors">'];

    for (var p in currentCountriesColors) {
        var py = getPaysByIso(p);
        if (!py) {
            continue;
        }
        l.push('<li><span class="legende_color" style="background-color:#' + currentCountriesColors[p] + '"></span>');
        l.push(py['pays_nom_' + lg]);
        l.push('</li>');
    }
    l.push('</ul>');
    return (l.join(''));

}

/**
 * Génère la légende en fonction de la taille des ronds
 * @todo à faire
 * */
function updateLegendeCircles(indic) {

    var h = ['<ul class="legende legende_colors">'];

    var maxValue = Math.abs(realMinBulletSizeValue) > maxBulletSizeValue ? Math.abs(realMinBulletSizeValue) : maxBulletSizeValue;
    var minValue = realMinBulletSizeValue < 0 ? 0 : realMinBulletSizeValue;

    var dif = maxValue - minValue;

    var valuesDif = dif / 100;


    var maxSize = maxBulletSize;
    var minSize = minBulletSize;
    var widthSize = (maxSize - minSize);


    var multi = 1;

    var n;
    if (realMinBulletSizeValue < 0) {

        n = calculateSize(valuesDif, 12);
        h.push(genCircle(-(Math.sqrt(n) * widthSize / Math.sqrt(dif)) * multi, -n));

        n = calculateSize(valuesDif, 2);
        h.push(genCircle((Math.sqrt(n) * widthSize / Math.sqrt(dif)) * multi * -1, -n));


        n = calculateSize(valuesDif, 2);
        h.push(genCircle((Math.sqrt(n) * widthSize / Math.sqrt(dif)) * multi, n));


        n = calculateSize(valuesDif, 12);
        h.push(genCircle((Math.sqrt(n) * widthSize / Math.sqrt(dif)) * multi, n));

    }
    else {
        n = calculateSize(valuesDif, 0.5);
        h.push(genCircle((Math.sqrt(n) * widthSize / Math.sqrt(dif)) * multi, n));


        n = calculateSize(valuesDif, 2);
        h.push(genCircle((Math.sqrt(n) * widthSize / Math.sqrt(dif)) * multi, n));

        n = calculateSize(valuesDif, 10);
        h.push(genCircle((Math.sqrt(n) * widthSize / Math.sqrt(dif)) * multi * (1), n));


    }


    h.push['</ul>'];

    return h.join('');
}

function genCircle(size, value) {
    size = Math.abs(size);
    value = shouldIMultiplyByMille() ? value / 1000 : value;
    return '<li class="legende_value"><div class="legende_circle ' + (value < 0 ? "neg" : "pos") + '" style="width:' + size + 'px;height:' + size + 'px;"></div>' + formatNb(value) + '</div></li>';
}

function calculateSize(number, quantity) {
    var r = String(Math.round(number * quantity));

    var rl = r.length;
    var rr = Math.round(rl / 4);

    var rs = r.substr(0, rr);
    return Number(rs) * Math.pow(10, (rl - rr));
}


/**
 * Génère la légende avec les listes des couleurs et leurs valeurs
 * @var indic object Indicateur
 * */
function updateLegendeColors(indic) {

    var l = ['<ul class="legende legende_colors">'];
    var indicL = indic.indicateur_values.length;

    /**
     * On parcourt la liste des valeurs possibles
     * */
    for (var p in indic.indicateur_values) {
        /**
         * On affiche la valeur
         * */
        l.push('<li><span class="legende_color" style="background-color:#' + indic.indicateur_values_colors[p] + '"></span>');

        /**
         * Premier item on l'affiche comme "moins de X"
         * */
        if (p == 0) {
            l.push(t('moins_de') + ' ' + formatLgNb(indic.indicateur_values[p], 1));
        } else {
            /**
             *  Valeurs intermédiaires
             *  Affiché entre "X-1 à X"
             **/
            l.push(formatLgNb(indic.indicateur_values[p - 1], 1) + ' ' + t('a') + ' ' + formatLgNb(indic.indicateur_values[p], 1));
        }

        if (p == indicL - 1) {
            /**
             * Dernier item de la liste, "X et plus"
             */
            l.push('<li><span class="legende_color" style="background-color:#' + indic.indicateur_values_colors[p] + '"></span>');

            l.push(formatLgNb(indic.indicateur_values[p], 1) + ' ' + t('ou_plus'));
        }

        l.push('</li>');
    }
    l.push('</ul>');

    return (l.join(''));
}
