<?php

header('Content-Type: text/javascript; charset=UTF-8');

$cacheFile = 'cache/'.md5($_SERVER['REQUEST_URI']);
if(rand(0,100) === 50 || !empty($_GET['nocache'])) {
    exec('rm -rf cache/*');
}

if(file_exists($cacheFile)) {
    header('X-Cache: Agressive');
    readfile($cacheFile);
    die();
}

/**
 * Paramètres
 */
if (empty($_GET['query']) || empty($_GET['params'])) {
    die(json_encode('query & params nécessaires'));
}

/**
 * Connexion à la base
 */
$db = new SQLite3('database.sqlite');
if (!$db) {
    die(json_encode('Connexion BDD failed ...'));
}

/**
 * On récupère la liste des requêtes
 */
$sqls = json_decode(file_get_contents('sql.json'), true);

/**
 * On cherche la query
 */
if (empty($sqls[$_GET['query']])) {
    die(json_encode('Query inexistante : ' . $_GET['query']));
}


/**
 * La requête SQL brute
 * */
$sqlQuery = $sqls[$_GET['query']];

/**
 * Gestion des paramètres "noms de champs" à remplacer à la main
 * Ils sont représentés entre crochets []
 * */

$params = json_decode($_GET['params']);
foreach ($params as $k => $v) {
    if(substr($k,0,1) == '[') {
        /**
         * On le supprime pour ne pas faire de BindValue plus tard
         * */
        unset($params->$k);
        
        /**
         * Et on met sa valeur brute
         * @todo vérifier les injections SQL
         * */
        $sqlQuery = str_replace($k,$v,$sqlQuery);
    }
}

   //echo $sqlQuery; 
/**
 * On prépare la requete et les paramètres
 */
$req = $db->prepare($sqlQuery);


/**
 * On lie les paramètres à la requête
 */
foreach ($params as $k => $v) {
    $req->bindValue($k, $v);
}

/**
 * On met tout la requête dans un tableau
 */
$jsonRes = array();
$res = $req->execute();
while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
    $jsonRes[] = $row;
}

/**
 * Et on renvoi en json ... 
 */
$res =  json_encode($jsonRes);
file_put_contents($cacheFile,$res);
echo $res;